% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_functions.R
\name{plot.hdlp}
\alias{plot.hdlp}
\title{Plot Impulse Responses obtained from HDLP.}
\usage{
\method{plot}{hdlp}(
  x,
  y = NULL,
  response = NULL,
  impulse = NULL,
  states = NULL,
  units = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{Output of the \code{HDLP()} function.}

\item{y}{Has no function, included for compatibility with \code{plot.default()}.}

\item{response}{Name of the response variable (\code{y} in \code{HDLP()}).}

\item{impulse}{Name of the shock variable (\code{x} in \code{HDLP()}).}

\item{states}{Optional names of the states (when applicable). If not provided, names
will be determined from \code{x}.}

\item{units}{Units of the response variable (y-axis label).}

\item{title}{String containing title of the plot; can be used to overwrite default
generated based on the names of the \code{response} and \code{impulse} variables.}

\item{...}{Other arguments forwarded to plot function (currently inactive).}
}
\value{
A \code{ggplot} object.
}
\description{
Plot Impulse Responses obtained from HDLP.
}
