% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamics.R
\name{dynamics}
\alias{dynamics}
\title{Productivity Dynamics}
\usage{
dynamics(df, x, s, id, tm, typ = "df")
}
\arguments{
\item{df}{A data frame sorted by the time period column.}

\item{x}{A string indicating the productivity (or analogous measures) column.}

\item{s}{A string indicating the market share column.}

\item{id}{A string indicating the identity column.}

\item{tm}{A string indicating the time period column.}

\item{typ}{Relevant types of productivity dynamics. Options include "df" for
Diewert-Fox decomposition (by default), "bhc" for Baily-Hulten-Campbell, "gr" for
Griliches-Regev, "fhk" for Foster-Haltiwanger-Krizan, "bg" for Baldwin-Gu, and
"mp" for Melitz-Polanec.}
}
\value{
A data frame consisting of the time period and firm contributions.
}
\description{
Productivity dynamics reflect firm contributions to
productivity growth over periods when firms enter or
exit an industry. \code{dynamics} summarises a series
of decomposition methods that are centred on the contributions
from incumbents, entrants and exits. It applies to other
weighted aggregation measures analogous to aggregate productivity
as well.
}
\examples{
# Use the built-in data set "firms"
# DF decomposition of firm dynamics
dym_df <- dynamics(firms, "tfp", "s", "id", "t")
# BG decomposition of firm dynamics
dym_bg <- dynamics(firms, "tfp", "s", "id", "t", "bg")

}
