% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqdiffusion.R
\name{seqdiffusion}
\alias{seqdiffusion}
\title{Enables fitting various sequential diffusion curves.}
\usage{
seqdiffusion(
  y,
  w = NULL,
  cleanlead = c(TRUE, FALSE),
  loss = 2,
  cumulative = c(TRUE, FALSE),
  pvalreps = 0,
  eliminate = c(FALSE, TRUE),
  sig = 0.05,
  verbose = c(FALSE, TRUE),
  type = c("bass", "gompertz", "gsgompertz", "weibull"),
  method = c("L-BFGS-B", "Nelder-Mead", "BFGS", "hjkb", "Rcgmin", "bobyqa"),
  maxiter = 500,
  opttol = 1e-06,
  multisol = c(FALSE, TRUE),
  initpar = c("linearize", "preset"),
  mscal = c(TRUE, FALSE),
  bootloss = c("smthempir", "empir", "se"),
  ...
)
}
\arguments{
\item{y}{matrix containing in each column the adoption per period for generation k}

\item{w}{matrix containing in each column the curve parameters for generation k (see note). Parameters set to NA will be
optimised. If \code{w = NULL} (default) all parameters are optimized.}

\item{cleanlead}{removes leading zeros for fitting purposes (default == T)}

\item{loss}{the l-norm (1 is absolute errors, 2 is squared errors)}

\item{cumulative}{If TRUE optimization is done on cumulative adoption.}

\item{pvalreps}{bootstrap repetitions to estimate (marginal) p-values}

\item{eliminate}{if TRUE eliminates insignificant parameters from the
estimation. Forces \code{pvalreps = 1000} if left to 0.}

\item{sig}{significance level used to eliminate parameters}

\item{verbose}{if TRUE console output is provided during estimation (default
== F)}

\item{type}{of diffusion curve to use. This can be "bass", "gompertz",
"gsgompertz" and "weibull"}

\item{method}{optimization method to use. This can be "nm" for Nelder-Meade or
"hj" for Hooke-Jeeves. #' @param maxiter number of iterations the optimiser
takes (default == \code{10000} for "nm" and \code{Inf} for "hj")}

\item{opttol}{Tolerance for convergence (default == 1.e-06)}

\item{multisol}{when \code{"TRUE"} multiple optmisation solutions from different initialisations of the market parameter are used (default == \code{"FALSE"})}

\item{initpar}{vector of initalisation parameters. If set to \code{preset} a predfined set of internal initalisation parameters is used while \code{"linearize"} uses linearised initalisation methods (default == \code{"linearize"}.}

\item{mscal}{scales market potential at initalisation with the maximum of the observed market potential for better optimization results (default == \code{TRUE})}
}
\value{
Returns an object of class \code{seqdiffusion}, which contains:
\itemize{
\item \code{type} diffusion model type used
\item \code{diffusion} returns model specification for each generation (see
\code{\link{diffusion}} for details)
\item \code{call} calls function fitted
\item \code{w} named matrix of fitted parameters for each generation
\item \code{y} matrix of actuals
\item \code{mse} insample Mean Squared Error for each generation
\item \code{pval} all p-values for \code{w} at each generation
}
}
\description{
This function fits diffusion curves of the type \code{"bass"},
\code{"gompertz"}, \code{gsgompertz} or \code{weibull} across generations.
Parameters are estimated for each generation individually by minimizing the
Mean Squared Error with subplex algorithms from the optimx package.
Optionally p-values of the coefficients can be determined via bootstraping.
Furthermore, the bootstrapping allows removing insignificant parameters from
the optimisation process.
}
\section{Bass curve}{

The optimization of the Bass curve is initialized by the linear
approximation suggested in Bass (1969).
}

\section{Gompertz curve}{

The initialization of the Gompertz curve uses the
approach suggested by Jukic et al. (2004), but is adapted to allow for the
non-exponential version of the Gompertz curve. This makes the market potential
parameter equivalent to the Bass curves and the market potential from
Bass curve is used for initialization.
}

\section{Gamma/Shifted Gompertz}{

The curve is initialized by assuming the shift operator to be 1 and 
becomes equivalent to the Bass curve, as shown in Bemmaor (1994). A Bass
curve is therefore used as an estimator for the remaining initial parameters.
}

\section{Weibull}{

The initialization is obtained through by a linear approximation
median-ranked OLS described in Sharif and Islam 1980.
}

\examples{
  fit <- seqdiffusion(tsIbm)
  plot(fit)

}
\references{
\itemize{
\item{For an introduction to diffusion curves see Ord K., Fildes R., Kourentzes N. (2017) \href{https://wessexlearning.com/products/principles-of-business-forecasting-2nd-ed}{Principles of Business Forecasting 2e}. \emph{Wessex Press Publishing Co.}, Chapter 12.}
\item{Bass, F.M., 1969. A new product growth for model consumer durables. Management Science 15(5), 215-227.}
\item{Bemmaor, A. 1994. Modeling the Diffusion of New Durable Goods: Word-of-Mouth Effect versus Consumer Heterogeneity. In G. Laurent, G.L. Lilien and B. Pras (Eds.). Research Traditions in Marketing. Boston: Kluwer, pp. 201-223.}
\item{Jukic, D., Kralik, G. and Scitovski, R., 2004. Least-squares fitting Gompertz curve. Journal of Computational and Applied Mathematics, 169, 359-375.}
\item{Sharif, N.M. and Islam, M.N. 1980. The Weibull Distribution as a General Model for Forecasting Technological Change. Technological Forecasting and Social Change, 18, 247-256.}
}
}
\seealso{
\code{\link{plot.seqdiffusion}} and \code{\link{print.seqdiffusion}}.
}
\author{
Oliver Schaer, \email{info@oliverschaer.ch},

Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{internal}
