% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifrSE.R
\name{rifrSE}
\alias{rifrSE}
\title{Inference of recentered influence function regression (RIF regression)}
\usage{
rifrSE(formula, data, weights = NULL, method = "quantile", quantile = 0.5,
  kernel = "gaussian", Nboot = 100, confidence = 0.95)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted in the RIF regression.}

\item{data}{a data frame containing the variables and weights of the model.}

\item{weights}{an optional vector of weights of x to be used in the computation of the
recentered influence function. Should be NULL or a numeric vector. Should be inside selected
data frame in the function and between quotation marks.}

\item{method}{the distribution statistic for which the recentered influence function is
estimated. Options are "quantile", "gini" and "variance". Default is "quantile".}

\item{quantile}{quantile to be used when method "quantile" is selected. Must be a numeric between
0 and 1. Default is 0.5 (median). Only a single quantile can be used.}

\item{kernel}{a character giving the smoothing kernel to be used in method "quantile". Options
are "gaussian", "rectangular", "triangular", "epanechnikov", "biweight", "cosine"
or "optcosine". Default is "gaussian".}

\item{Nboot}{the number of bootstrap replicates. Default is 100.}

\item{confidence}{significance level for estimation of the confidence interval of the
fitted model. Default is 0.95.}
}
\value{
A data frame containing the results of the RIF regression.
    \item{Coef}{estimated coefficients of the original (non bootstrapped) RIF regression}
    \item{lower}{lower bound of confidence interval of estimated coefficient}
    \item{upper}{upper bound of confidence interval of estimated coefficient}
    \item{SE}{standard error}
    \item{Z Value}{Z value}
    \item{P Value}{P value}
    \item{Signif}{Significance codes of P: 0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1}
}
\description{
Inference of a RIF Regression using a bootstrap method.
}
\details{
RIF Regressions can be used to estimate the marginal effects of covariates on
distributional statistics (such as quantiles, gini and variance). It is based on the recentered
influence function of a statistic. The transformed RIF is used as the dependent variable in an
ordinary least squares regression. RIF regressions are mostly used to estimate the marginal
effect of covariates on distributional statistics of income or wealth.

The standard errors, confidence intervals and Z- and P-values are calculated by using a
standard bootstrap method (from boot package).
}
\examples{
data(mex_inc_2008)

#Recentered influence funtion of 20th quantile
rifr_q <- rifrSE(income~hh_structure+education, data=mex_inc_2008, weights="factor",
method="quantile", quantile=0.2, kernel="gaussian", Nboot=100, confidence=0.95)

#Recentered influence funtion of the gini coefficient
rifr_gini <- rifrSE(income~hh_structure+education, data=mex_inc_2008, weights="factor",
method="gini", Nboot=100, confidence=0.95)


}
\references{
Firpo, S., N. Fortin and T. Lemieux (2009) Unconditional quantile regressions. \emph{Econometrica},
77(3), p. 953-973.

Heckley G, U.-G. Gerdtham U-G and G. Kjellsson (2016) A general method for decomposing the
causes of socioeconomic inequality in health. \emph{Journal of Health Economics},48, p. 89–106.

Pereira, J. and A. Galego (2016) The drivers of wage inequality across Europe, a recentered
influence function regression approach, \emph{10th Annual Meeting of the Portuguese Economic
Journal}, University of Evora.
}
\seealso{
\code{\link{rif}}
         \code{\link{rifr}}
}
