% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrtr-package.R
\docType{data}
\name{mc_attitudes}
\alias{mc_attitudes}
\title{McMaster Attitudes Data Set.}
\format{
A data frame with 1230 rows and 39 variables:
\describe{
\item{id}{Unique identifier for respondents}
\item{choice}{Mode of transportation chosen: Car, HSR (local transit), Walk}
\item{LAT}{Latitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{LONG}{Longitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{license}{Indicator variable for holding a driver license: Yes/No}
\item{vehicle}{Indicator variable for having individual access to a private car (i.e., car not shared with other household members): Yes/No}
\item{gender}{Woman/Man}
\item{age}{Age in years}
\item{visa}{Visa status of student: Domestic}
\item{living_arrangements}{Living arrangements DURING THE SCHOOL YEAR are: 1:Living with my family or relatives/By myself off-campus/Shared off-campus accommodations}
\item{level}{Level of studies: Undergraduate Year I (UG I)/Undergraduate Year II  (UG I)/Undergraduate Year III  (UG III)/Undergraduate Year IV (UG IV)/Undergraduate Year V (UG V)/Masters/PhD/Other (Diploma or Certificate)}
\item{Active_Neighborhood}{Response to statement "I like to live in a neighborhood where there's a lot going on": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{Community}{Response to statement "There is a sense of community in my neighborhood": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{Neighbors}{Response to statement "I know my neighbors well": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{Safe_Walk}{Response to statement "I feel safe and secure when walking in my neighborhood": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{Shops_Important}{Response to statement "Having shops and services within walking distance of my home is important to me": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{Travel_Alone}{Response to statement "I like traveling alone": Five point likert scale from Strongly Disagree to Strongly Agree, including a neutral point}
\item{DAUID}{Unique ID of Dissemination Area of the Census}
\item{Rate_Couple_Child}{Proportion of families that are couples with children out of all families in Dissemination Area}
\item{Rate_SW_Child}{Proportion of families that are single parent (woman) with children out of all families in Dissemination Area}
\item{Rate_SM_Child}{Proportion of families that are single parent (man) with children out of all families in Dissemination Area}
\item{Mean_Children}{Average number of children at home per census family in Dissemination Area}
\item{Rate_Non_Canadian}{Proportion of non-Canadian residents to total population in Dissemination Area}
\item{Median_HH_Income}{Median family income in Dissemination Area in $10,000}
\item{Mean_HH_Income}{Mean family income in Dissemination Area in $10,000}
\item{Rate_Unemployment}{Unemployment rate in Dissemination Area}
\item{Rate_1yr_Move}{Proportion of residents that moved to Dissemination Area in the year previous to the census}
\item{Rate_5yr_Move}{Proportion of residents that moved to Dissemination Area in the 5 years previous to the census}
\item{Rate_Public}{Proportion of residents in Dissemination Area that used public transportation to commute to work}
\item{Rate_Walk}{Proportion of residents in Dissemination Area that walked to work}
\item{Rate_Cycle}{Proportion of residents in Dissemination Area that cycled to work}
\item{AREA}{Area of Dissemination Area in square kilometers}
\item{LUM}{Entropy-based land use mix index in Dissemination Area: lower values mean more homogenous land uses, higher values greater mix of uses}
\item{SIDEWALK_DENSITY}{Sidewalk density in Dissemination Area in km/sq.km}
\item{STREET_DENSITY}{Street density in Dissemination Area in km/sq.km}
\item{INTERSECTION_DENSITY}{Intersection density in Dissemination Area in 1/sq.km}
\item{SF_P_RATIO}{Ratio of building footprint to parcel area in Dissemination Area: a measure of density of development}
\item{EMPLOYMENT_DENSITY}{Employment density in Dissemination Area in jobs/sq.km}
\item{POPULATION_DENSITY}{Population density in Dissemination Area in people/sq.km}
}
}
\source{
P\'{a}ez, A. (2013). Mapping travelers’ attitudes: does space matter?. Journal of Transport Geography, 26, 117-125. (https://doi.org/10.1016/j.jtrangeo.2012.09.002)
}
\usage{
data(mc_attitudes)
}
\description{
A data set containing information about \emph{students} commuting to McMaster University. Data were collected
by means of a travel survey in the fall of 2010. Respondents were asked about their mode of
travel to McMaster University, in Hamilton, Canada. They were also asked to respond to a series of attitudinal
statements. The data set contains relevant attributes about the respondents. The format of the table is wide,
with each row representing an individual respondent. These variables were augmented with information from the
2011 Census of Canada and land use information from local sources.
}
\examples{
 data(mc_attitudes)
 summary(mc_attitudes$Community)
}
\keyword{datasets}
