% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.root.time.R
\name{set.root.time}
\alias{set.root.time}
\title{Adds root time to a tree}
\usage{
set.root.time(tree, present = 0)
}
\arguments{
\item{tree}{A \code{phylo}, \code{mutiPhylo} or \code{dispRity} object that contains trees.}

\item{present}{The age of the most recent tip. By default this is set to \code{0}.}
}
\description{
Adds or replace root time to a tree by calculating it's root's depth
}
\examples{
## A random tree with no root.time
my_tree <- rtree(10)
my_tree$root.time # is NULL
## Adding a root time
my_tree <- set.root.time(my_tree)
my_tree$root.time # is not NULL
## Rewrite the root time with a different present
my_tree <- set.root.time(my_tree, present = 10)
my_tree$root.time # is older

}
