% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcrete.R
\name{distcrete}
\alias{distcrete}
\title{Discretise a distribution}
\usage{
distcrete(name, interval, ..., w = 0.5, anchor = 0)
}
\arguments{
\item{name}{The name of a distribution function (e.g.,
\code{norm}, \code{gamma}).  The distribution must have a cdf
function (e.g., \code{pnorm}) and a quantile function (e.g.,
\code{qnorm}) defined.}

\item{interval}{The interval to discretise the interval onto.}

\item{...}{Parameters to \code{cdf}.  Can be matched positionally
or by name.}

\item{w}{How to weight the endpoints; must be between 0 and 1.
If 0.5 then integration happens centred around the interval, if
0 floor, if 1 then ceiling.}

\item{anchor}{Any location that is a valid \code{x}}
}
\description{
Discretise a distribution.
}
\examples{
library(distcrete)
set.seed(415)
d0 <- distcrete("gamma", 1, shape = 3, w = 0)
d0$d(1:10)
d0$p(c(.1,.5))
d0$q(c(.1,.5))
d0$r(10)
}
\author{
Rich FitzJohn
}
