get_jacobian.glm <- function(m, verbose){
  stopifnot(is(m, "glm"), !is.null(m[["x"]]))
  if(isTRUE(verbose)) message("Calculating Jacobian from glm object...")
  f <- function(theta){
    m[["family"]][["linkinv"]](colSums(theta * t(m[["x"]])))
  }
  output <- as.matrix(drop(calculus::jacobian(f = f, var = unname(m[["coefficients"]]))))
  return(output)
}
