% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosis.R, R/mean.R, R/skewness.R, R/stdev.R,
%   R/variance.R
\name{kurtosis}
\alias{kurtosis}
\alias{kurtosis_exc}
\alias{mean.dst}
\alias{skewness}
\alias{stdev}
\alias{variance}
\title{Moments of a Distribution}
\usage{
kurtosis(distribution)

kurtosis_exc(distribution)

\method{mean}{dst}(x, ...)

skewness(distribution)

stdev(distribution)

variance(distribution)
}
\arguments{
\item{x, distribution}{Distribution to evaluate.}

\item{...}{When calculating the mean via integration of the quantile
function, arguments passed to \code{stats::integrate()}.}
}
\value{
A single numeric.
}
\description{
Get common moment-related quantities of a
distribution: \code{mean}, \code{variance}, standard deviation (\code{stdev}),
\code{skewness}, and \code{kurtosis} or excess kurtosis (\code{kurtosis_exc}).
If these quantities are not supplied in the
distribution's definition, a numerical algorithm may be used.
}
\details{
If there is no method associated with a subclass of
\code{x}, then moments are calculated using
\code{stats::integrate()} from the density function.
}
\note{
Beware that if a quantity is being calculated numerically
for a non-continuous (e.g., discrete) distribution, the calculation
could be highly approximate. An upcoming version of distionary will
resolve this issue.
}
\examples{
a <- dst_gp(1, 0.5)
b <- dst_unif(0, 1)
c <- dst_norm(3, 4)
mean(a)
variance(b)
kurtosis(c)
kurtosis_exc(c)
}
