% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{range.dst}
\alias{range.dst}
\title{Range of Distribution}
\usage{
\method{range}{dst}(distribution, ...)
}
\arguments{
\item{distribution}{Distribution to compute range from.}

\item{...}{Not used; vestige of the \code{base::range()} S3 generic.}
}
\value{
Vector of length two, containing the minimum and maximum
values of a distribution.
}
\description{
Range returns a vector of length two, with the minimum and maximum
values of the (support of the) distribution.
}
\details{
If there are no methods for the distribution's class,
the range is calculated
using \code{eval_quantile()} at 0 and at 1.
}
\examples{
a <- dst_gp(1, 0.5)
b <- dst_unif(0, 1)
c <- dst_norm(3, 4)
range(a)
range(b)
range(c)
}
