% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_weibull.R
\name{dist_weibull}
\alias{dist_weibull}
\title{The Weibull distribution}
\usage{
dist_weibull(shape, scale)
}
\arguments{
\item{shape, scale}{shape and scale parameters, the latter defaulting to 1.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Generalization of the gamma distribution. Often used in survival and
time-to-event analyses.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_weibull.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_weibull.html}

In the following, let \eqn{X} be a Weibull random variable with
shape parameter \code{shape} = \eqn{k} and scale parameter \code{scale} = \eqn{\lambda}.

\strong{Support}: \eqn{[0, \infty)}

\strong{Mean}:

\deqn{
    E(X) = \lambda \Gamma\left(1 + \frac{1}{k}\right)
  }{
    E(X) = \lambda \Gamma(1 + 1/k)
  }

where \eqn{\Gamma} is the gamma function.

\strong{Variance}:

\deqn{
    \text{Var}(X) = \lambda^2 \left[\Gamma\left(1 + \frac{2}{k}\right) - \left(\Gamma\left(1 + \frac{1}{k}\right)\right)^2\right]
  }{
    Var(X) = \lambda^2 [\Gamma(1 + 2/k) - (\Gamma(1 + 1/k))^2]
  }

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{k}{\lambda}\left(\frac{x}{\lambda}\right)^{k-1}e^{-(x/\lambda)^k}, \quad x \ge 0
  }{
    f(x) = (k/\lambda)(x/\lambda)^(k-1) e^(-(x/\lambda)^k), x >= 0
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = 1 - e^{-(x/\lambda)^k}, \quad x \ge 0
  }{
    F(x) = 1 - e^(-(x/\lambda)^k), x >= 0
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \sum_{n=0}^\infty \frac{t^n\lambda^n}{n!} \Gamma\left(1+\frac{n}{k}\right)
  }{
    E(e^(tX)) = \sum_(n=0)^\infty (t^n \lambda^n / n!) \Gamma(1 + n/k)
  }

\strong{Skewness}:

\deqn{
    \gamma_1 = \frac{\mu^3 - 3\mu\sigma^2 - \mu^3}{\sigma^3}
  }{
    \gamma_1 = (\mu_3 - 3\mu\sigma^2 - \mu^3) / \sigma^3
  }

where \eqn{\mu = E(X)}, \eqn{\sigma^2 = \text{Var}(X)}, and the third
raw moment is

\deqn{
    \mu^3 = \lambda^3 \Gamma\left(1 + \frac{3}{k}\right)
  }{
    \mu_3 = \lambda^3 \Gamma(1 + 3/k)
  }

\strong{Excess Kurtosis}:

\deqn{
    \gamma_2 = \frac{\mu^4 - 4\gamma_1\mu\sigma^3 - 6\mu^2\sigma^2 - \mu^4}{\sigma^4} - 3
  }{
    \gamma_2 = (\mu_4 - 4\gamma_1\mu\sigma^3 - 6\mu^2\sigma^2 - \mu^4) / \sigma^4 - 3
  }

where the fourth raw moment is

\deqn{
    \mu^4 = \lambda^4 \Gamma\left(1 + \frac{4}{k}\right)
  }{
    \mu_4 = \lambda^4 \Gamma(1 + 4/k)
  }
}
\examples{
dist <- dist_weibull(shape = c(0.5, 1, 1.5, 5), scale = rep(1, 4))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Weibull]{stats::Weibull}
}
