% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical.R
\name{empirical}
\alias{empirical}
\alias{dempirical}
\alias{pempirical}
\alias{qempirical}
\alias{mempirical}
\title{The empirical distribution}
\usage{
dempirical(x, data, log = FALSE)

pempirical(q, data, log.p = FALSE, lower.tail = TRUE)

qempirical(p, data, lower.tail = TRUE, log.p = FALSE)

mempirical(r = 0, data, truncation = NULL, lower.tail = TRUE)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{data}{data vector}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), moments are \eqn{E[x^r|X \le y]}, otherwise, \eqn{E[x^r|X > y]}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the Pareto distribution}

\item{truncation}{lower truncation parameter, defaults to NULL.}
}
\value{
dempirical returns the density, pempirical the distribution function, qempirical the quantile function, mempirical gives the rth moment of the distribution or a function that allows to evaluate the rth moment of the distribution if truncation is NULL..
}
\description{
Density, distribution function, quantile function, and raw moments for the empirical distribution.
}
\details{
The density function is a standard Kernel density estimation for 1e6 equally spaced points. The cumulative Distribution Function:

 \deqn{F_n(x) = \frac{1}{n}\sum_{i=1}^{n}I_{x_i \leq x}}

 The y-bounded r-th raw moment of the empirical distribution equals:

 \deqn{ \mu^{r}_{y} = \frac{1}{n}\sum_{i=1}^{n}I_{x_i \leq x}x^r}
}
\examples{
#'
## Generate random sample to work with
x <- rlnorm(1e5, meanlog = -0.5, sdlog = 0.5)

## Empirical density
plot(x = seq(0, 5, length.out = 100), y = dempirical(x = seq(0, 5, length.out = 100), data = x))

# Compare empirical and parametric quantities
dlnorm(0.5, meanlog = -0.5, sdlog = 0.5)
dempirical(0.5, data = x)

plnorm(0.5, meanlog = -0.5, sdlog = 0.5)
pempirical(0.5, data = x)

qlnorm(0.5, meanlog = -0.5, sdlog = 0.5)
qempirical(0.5, data = x)

mlnorm(r = 0, truncation = 0.5, meanlog = -0.5, sdlog = 0.5)
mempirical(r = 0, truncation = 0.5, data = x)

mlnorm(r = 1, truncation = 0.5, meanlog = -0.5, sdlog = 0.5)
mempirical(r = 1, truncation = 0.5, data = x)

## Demonstration of log functionailty for probability and quantile function
quantile(x, 0.5, type = 1)
qempirical(p = pempirical(q = quantile(x, 0.5, type = 1), data = x, log.p = TRUE),
data = x, log.p = TRUE)

## The zeroth truncated moment is equivalent to the probability function
pempirical(q = quantile(x, 0.5, type = 1), data = x)
mempirical(truncation = quantile(x, 0.5, type = 1), data = x)

## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
#for large enough samples.
mean(x)
mempirical(r = 1, data = x, truncation = 0, lower.tail = FALSE)

sum(x[x > quantile(x, 0.1)]) / length(x)
mempirical(r = 1, data = x, truncation = quantile(x, 0.1), lower.tail = FALSE)
#'
}
