% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_operations.R
\name{set_operations}
\alias{set_operations}
\alias{union_number_lines}
\alias{intersect_number_lines}
\alias{subtract_number_lines}
\title{Set operations on number line objects}
\usage{
union_number_lines(x, y)

intersect_number_lines(x, y)

subtract_number_lines(x, y)
}
\arguments{
\item{x}{\code{[\link{number_line}]}}

\item{y}{\code{[\link{number_line}]}}
}
\value{
\code{[\link{number_line}]}; \code{list}
}
\description{
Perform set operations on a pair of \code{[\link{number_line}]}s.
}
\details{
\bold{\code{union_number_lines()}} - Combined the range of \code{x} and that of \code{y}

\bold{\code{intersect_number_line()}} - Subset of \code{x} that overlaps with \code{y} and vice versa

\bold{\code{subtract_number_lines()}} - Subset of \code{x} that does not overlap with \code{y} and vice versa.

The \code{direction} of the returned \code{[\link{number_line}]} will be that of the widest one (\code{x} or \code{y}).
If \code{x} and \code{y} have the same length, it'll be an \code{"increasing"} direction.

If \code{x} and \code{y} do not overlap, \code{NA} (\code{"NA ?? NA"}) is returned.
}
\examples{
nl_1 <- c(number_line(1, 5), number_line(1, 5), number_line(5, 9))
nl_2 <- c(number_line(1, 2), number_line(2, 3), number_line(0, 6))

# Union
nl_1; nl_2; union_number_lines(nl_1, nl_2)


nl_3 <- number_line(as.Date(c("01/01/2020", "03/01/2020","09/01/2020"), "\%d/\%m/\%Y"),
                    as.Date(c("09/01/2020", "09/01/2020","25/12/2020"), "\%d/\%m/\%Y"))

nl_4 <- number_line(as.Date(c("04/01/2020","01/01/2020","01/01/2020"), "\%d/\%m/\%Y"),
                    as.Date(c("05/01/2020","05/01/2020","03/01/2020"), "\%d/\%m/\%Y"))

# Intersect
nl_3; nl_4; intersect_number_lines(nl_3, nl_4)

# Subtract
nl_3; nl_4; subtract_number_lines(nl_3, nl_4)

}
\seealso{
\code{\link{number_line}};  \code{\link{overlaps}}
}
