% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R, R/summary.hdlm.R, R/summary.hdlmm.R,
%   R/summary.monotone.R, R/summary.tdlm.R, R/summary.tdlmm.R, R/summary.tdlnm.R
\name{summary}
\alias{summary}
\alias{summary.hdlm}
\alias{summary.hdlmm}
\alias{summary.monotone}
\alias{summary.tdlm}
\alias{summary.tdlmm}
\alias{summary.tdlnm}
\title{summary}
\usage{
summary(x, conf.level = 0.95, ...)

\method{summary}{hdlm}(x, conf.level = 0.95, mcmc = FALSE, ...)

\method{summary}{hdlmm}(x, conf.level = 0.95, mcmc = FALSE, ...)

\method{summary}{monotone}(
  x,
  conf.level = 0.95,
  pred.at = NULL,
  cenval = 0,
  exposure.se = NULL,
  mcmc = FALSE,
  verbose = TRUE,
  ...
)

\method{summary}{tdlm}(x, conf.level = 0.95, mcmc = FALSE, ...)

\method{summary}{tdlmm}(
  x,
  conf.level = 0.95,
  marginalize = "mean",
  log10BF.crit = 0.5,
  mcmc = FALSE,
  verbose = TRUE,
  ...
)

\method{summary}{tdlnm}(
  x,
  conf.level = 0.95,
  pred.at = NULL,
  cenval = 0,
  exposure.se = NULL,
  mcmc = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class 'tdlm', 'tdlmm', 'tdlnm', 'hdlm', 'hdlmm', 'monotone'}

\item{conf.level}{confidence level for computation of credible intervals}

\item{...}{additional parameters}

\item{mcmc}{keep all mcmc iterations (large memory requirement)}

\item{pred.at}{numerical vector of exposure values to make predictions for 
at each time period}

\item{cenval}{scalar exposure value that acts as a reference point for 
predictions at all other exposure values}

\item{exposure.se}{scalar smoothing factor, if different from model}

\item{verbose}{show progress in console}

\item{marginalize}{value(s) for calculating marginal DLMs, defaults to "mean", 
can also specify a percentile from 1-99 for all other exposures, or
a named vector with specific values for each exposure}

\item{log10BF.crit}{Bayes Factor criteria for selecting exposures and interactions, 
such that log10(BayesFactor) > x. Default = 0.5.}
}
\value{
list of summary outputs of the model fit
}
\description{
summary generic function for S3method
}
