% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\docType{class}
\name{dmbc_ic-class}
\alias{dmbc_ic-class}
\alias{dmbc_ic}
\title{An S4 class to represent the comparison of a set of DMBC models.}
\description{
An S4 class to represent the comparison of a set of DMBC models through
  the dissimilarity model-based clustering information criterion (DCIC).
}
\section{Slots}{

\describe{
\item{\code{logprior}}{An object of class \code{matrix} providing the
log-prior values corresponding to different values of \emph{p} and
\emph{G}.}

\item{\code{logmlik}}{An object of class \code{matrix} providing the
marginal log-likelihood values corresponding to different values of
\emph{p} and \emph{G}.}

\item{\code{logcorrfact}}{An object of class \code{matrix} providing the
logarithm of the correction factors corresponding to different values of
\emph{p} and \emph{G}.}

\item{\code{DCIC}}{An object of class \code{matrix} providing the values
of the DCIC index corresponding to different values of \emph{p} and
\emph{G}.}

\item{\code{post.est}}{An object of class \code{list}; named list with
elements representing the parameter estimates corresponding to different
values of \emph{p} and \emph{G}.}

\item{\code{est}}{A length-one character vector representing the estimate
type used in computing the DCIC index. Possible values are \code{mean},
\code{median}, \code{ml} and \code{map}. See \code{\link{dmbc_ic}()} for
more details about these values.}

\item{\code{res_last_p}}{An object of class \code{list}; list of
\code{dmbc_fit_list} objects with the results of fitting the DMBC
models corresponding to the last value of \emph{p}. This is needed in case
of an update of the DCIC calculations using additional \emph{p} and/or
\emph{G} values.}
}}

\examples{
showClass("dmbc_ic")

}
\references{
Venturini, S., Piccarreta, R. (2021), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Journal of Statistical Software, 100, 16, 1--35, <10.18637/jss.v100.i16>.
}
