% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{splitt_kurtosis}
\alias{splitt_kurtosis}
\alias{splitt_moments}
\alias{splitt_mean}
\alias{splitt_skewness}
\alias{splitt_var}
\title{Moments of the split-t distribution}
\usage{
splitt_kurtosis(df, phi, lmd)

splitt_mean(mu, df, phi, lmd)

splitt_skewness(df, phi, lmd)

splitt_var(df, phi, lmd)
}
\arguments{
\item{df}{degrees of freedom (> 0, can be non-integer). df = Inf is allowed.}

\item{phi}{vector of scale parameters (> 0).}

\item{lmd}{vector of skewness parameters (> 0). If is 1, reduced to
symmetric student t distribution.}

\item{mu}{vector of location parameter. (The mode of the density)}
}
\value{
\code{splitt_mean} gives the mean. \code{splitt_var} gives the
variance. \code{splitt_skewness} gives the skewness. \code{splitt_kurtosis}
gives the kurtosis. (\code{splitt_mean},
\code{splitt_var},\code{splitt_skeness} and \code{splitt_kurtosis} are all
vectors.)

Invalid arguments will result in return value NaN, with a warning.
}
\description{
Computing the mean, variance, skewness and kurtosis for the split student-t
distribution.
}
\section{Functions}{
\itemize{
\item \code{splitt_kurtosis}: Kurtosis for the split-t distribution.

\item \code{splitt_skewness}: Skewness for the split-t distribution.

\item \code{splitt_var}: Variance for the split-t distribution.
}}

\examples{

mu <- c(0,1,2)
df <- rep(10,3)
phi <- c(0.5,1,2)
lmd <- c(1,2,3)

mean0 <- splitt_mean(mu, df, phi, lmd)
var0 <- splitt_var(df, phi, lmd)
skewness0 <- splitt_skewness(df, phi, lmd)
kurtosis0 <- splitt_kurtosis(df, phi, lmd)
}
\references{
Li, F., Villani, M., & Kohn, R. (2010). Flexible modeling of
conditional distributions using smooth mixtures of asymmetric student t
densities. Journal of Statistical Planning & Inference, 140(12), 3638-3654.
}
\seealso{
\code{\link{dsplitt}()}, \code{\link{psplitt}()},
\code{\link{qsplitt}()} and \code{\link{rsplitt}()} for the split-t
distribution.
}
\author{
Feng Li, Jiayue Zeng
}
\keyword{asymmetric}
\keyword{distribution}
\keyword{student-t}
