% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso.R
\name{dodgr_isodists}
\alias{dodgr_isodists}
\title{Calculate isodistance contours from specified points.}
\usage{
dodgr_isodists(
  graph,
  from = NULL,
  dlim = NULL,
  concavity = 0,
  length_threshold = 0,
  contract = TRUE,
  heap = "BHeap"
)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph. For \code{dodgr} street networks, this may be a network derived from either
\pkg{sf} or \pkg{silicate} ("sc") data, generated with
\link{weight_streetnet}.}

\item{from}{Vector or matrix of points \strong{from} which isodistances are to
be calculated.}

\item{dlim}{Vector of desired limits of isodistances in metres.}

\item{concavity}{A value between 0 and 1, with 0 giving (generally smoother
but less detailed) convex iso-contours and 1 giving highly concave (and
generally more detailed) contours.}

\item{length_threshold}{The minimal length of a segment of the iso-contour
to be made more convex according to the 'concavity` parameter.. Low values
will produce highly detailed hulls which may cause problems; if in doubt, or
if odd results appear, increase this value.}

\item{contract}{If \code{TRUE}, calculate isodists only to vertices in the
contract graph, in other words, only to junction vertices.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}
}
\value{
A single \code{data.frame} of isodistances as points sorted anticlockwise
around each origin (\code{from}) point, with columns denoting the \code{from} points
and \code{dlim} value(s). The isodistance contours are given as \code{id} values and
associated coordinates of the series of points from each \code{from} point at the
specified isodistances.
}
\description{
Calculates isodistances from input \code{data.frame} objects
(\code{graph}), which must minimally contain three columns of \code{from}, \code{to}, and
\code{d} or \code{dist}. If an additional column named \code{weight} or \code{wt} is present,
shortest paths are calculated according to values specified in that column,
while resultant isodistances are calculated from the \code{d} or \code{dist} column.
That is, the paths tracing isodistances from any point will be calculated
according to the minimal total sum of \code{weight} values (if present), while
reported isodistances will be total sums of \code{dist} values.

Graphs derived from Open Street Map street networks, via the
\link{weight_streetnet} function, have columns labelled \code{d}, \code{d_weighted},
\code{time}, and \code{time_weighted}. For these inputs, isodistances are always
routed using \code{d_weighted} (or \code{t_weighted} for times), while final
isodistances are sums of values of \code{d} (or \code{t} for times)- that is, of
un-weighted distances or times - along those paths.

Function is fully vectorized to calculate accept vectors of central points
and vectors defining multiple isodistances. Calculations use by default
parallel computation with the maximal number of available cores or threads.
This number can be reduced by specifying a value via
\verb{RcppParallel::setThreadOptions (numThreads = <desired_number>)}.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 100)
dlim <- c (1, 2, 5, 10, 20) * 100
d <- dodgr_isodists (graph, from = from, dlim)
}
\seealso{
Other iso: 
\code{\link{dodgr_isochrones}()},
\code{\link{dodgr_isoverts}()}
}
\concept{iso}
