% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcrd3fact.R
\name{fcrd3fact}
\alias{fcrd3fact}
\title{Analysis of Factorial Completely Randomized Design for 3 factors}
\usage{
fcrd3fact(data, fact.A, fact.B, fact.C, Multiple.comparison.test)
}
\arguments{
\item{data}{dependent variables}

\item{fact.A}{vector containing levels of first factor}

\item{fact.B}{vector containing levels of second factor}

\item{fact.C}{vector containing levels of third factor}

\item{Multiple.comparison.test}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result for both the factors as well as interaction.
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means.
}
\examples{
data(factorialdata)
#FCRD analysis along with dunccan test for two dependent var.
fcrd3fact(factorialdata[5:6],factorialdata$Nitrogen,
factorialdata$Phosphorus,factorialdata$Potassium,2)
}
