% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrtretransform.R
\name{sqrtretransform}
\alias{sqrtretransform}
\title{Re-transform the square root transformed data}
\usage{
sqrtretransform(transformed.mean, if.zero.present)
}
\arguments{
\item{transformed.mean}{vector of mean which needs to be re-transformed}

\item{if.zero.present}{0 if zero was present in the data prior to transformation of data.
1 if zero was absent in the data prior to transformation}
}
\value{
Square root re-transformed vector
}
\description{
Retransform the square root transformed data. When square root transformation is done, the mean of the treatments needs to be re-transformed for comparison.
}
\examples{
vector<-c(19,10,30,60,50,10,5)
#Square root re-transform and zero was absent in the data prior to transformation
sqrtretransform(vector,1)
}
