% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripplot.R
\name{stripplot}
\alias{stripplot}
\title{Analysis of Strip plot design}
\usage{
stripplot(data, block, column, row, mean.comparison.test)
}
\arguments{
\item{data}{dependent variables}

\item{block}{vector containing replications}

\item{column}{vector containing column strip levels}

\item{row}{vector containing row strip levels}

\item{mean.comparison.test}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means
}
\examples{
data(splitdata)
#Split data is used for sake of demonstration
#Using Date of sowing as Column factor and varieties as Row factor and using LSD test for Yield only
stripplot(splitdata[4],splitdata$Replication,splitdata$Date_of_Sowing,splitdata$Varities,1)
#Using Date of sowing as Column factor and varieties as Row factor and using LSD test for both var.
stripplot(splitdata[4:5],splitdata$Replication,splitdata$Date_of_Sowing,splitdata$Varities,1)
}
