% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donut_labels.R
\docType{data}
\name{donut_label}
\alias{donut_label}
\alias{StatLabelInt}
\alias{geom_label_int}
\alias{StatTextInt}
\alias{geom_text_int}
\alias{StatLabelExt}
\alias{geom_label_ext}
\alias{StatTextExt}
\alias{geom_text_ext}
\title{Create pie or donut label and text annotations}
\format{
An object of class \code{StatLabelInt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatTextInt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatLabelExt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatTextExt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
geom_label_int(
  mapping = NULL,
  data = NULL,
  stat = "label_int",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r = 1,
  ...
)

geom_text_int(
  mapping = NULL,
  data = NULL,
  stat = "text_int",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r = 1,
  ...
)

geom_label_ext(
  mapping = NULL,
  data = NULL,
  stat = "label_ext",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  layout = circle(),
  ...
)

geom_text_ext(
  mapping = NULL,
  data = NULL,
  stat = "text_ext",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  layout = circle(),
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointly specified with
\code{nudge_x} or \code{nudge_y}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{r}{Sets the radius to place label or text for internal donut}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{layout}{The layout function to effectively display text and labels}
}
\value{
None
}
\description{
The set of annotation functions utilizes layout functions to effectively distribute labels within the available space
Annotations are streamlined by leveraging pre-calculated special variables such as \code{.sum}, \code{.mean}, and \code{.n} (see Details).
\itemize{
\item The function \code{geom_label_int()} creates \code{geom_label}-like \strong{internal} donut layer as aggregation of passed values
\item The function \code{geom_text_int()} creates \code{geom_text}-like \strong{internal} donut layer as aggregation of passed values
\item The function \code{geom_label_ext()} creates \code{geom_label}-like \strong{external} donut layer of passed values
\item The function \code{geom_text_ext()} creates \code{geom_text}-like \strong{external} donut layer of passed values
}
}
\details{
The label functions supports \code{glue::glue()} for convenient label construction like \code{Total: {.sum}},
where \code{.sum} is pre-calculated variable. You can still use \code{glue::glue()} or \code{paste()}
functions to pass data.frame fields for label construction.

In addition to generic aesthetics like \code{color}, \code{fill}, \code{alpha}, etc., the following list of pre-calculated variables
is available for \code{geom_label_int()} and \code{geom_text_int()}:
\itemize{
\item \code{.sum}: Summation of the value field
\item \code{.mean}: Mean of the value field
\item \code{.median}: Median of the value field
\item \code{.n}: Observation count of the value field
\item \code{.prc}: Percentage of the value field
}

For \code{geom_label_ext()} and \code{geom_text_ext()}, which are suitable for external donut labels, the following list of
pre-calculated variables is available:
\itemize{
\item \code{.prc}: Percentage of the value field for the entire multiplicity
\item \code{.prc_grp}: Percentage of the value field for the group defined by \code{fill}
}
}
\examples{
# Create an example data set
n <- 30
set.seed(2021)
df <- dplyr::tibble(
  lvl1 = sample(LETTERS[1:5], n, TRUE),
  lvl2 = sample(LETTERS[6:24], n, TRUE),
  value = sample(1:20, n, TRUE),
  highlight_ext = sample(c(FALSE,TRUE), n, TRUE, c(.9, .1))) |>
 dplyr::mutate(highlight_int = dplyr::if_else(lvl1 == "A", TRUE, FALSE))

# Starting plot with doubled donuts and annotations for internal one
p <- dplyr::group_by(df, lvl1, lvl2, highlight_ext, highlight_int) |>
 dplyr::summarise(value = sum(value), .groups = "drop") |>
 packing(value, lvl1) |>
 ggplot(aes(value = value, fill = lvl1)) +
 geom_donut_int(aes(highlight = highlight_int), alpha=.5, r_int=.25) +
 geom_text_int(lineheight = .8, r=1.2, show.legend = FALSE,
  aes(label = "Sum {fill}:\n{.sum}-{scales::percent(.prc)}", col=lvl1)) +
 geom_donut_ext(aes(opacity = lvl2, highlight = highlight_ext)) +
 scale_fill_viridis_d(option = "inferno", begin = .1, end = .7) +
 scale_color_viridis_d(option = "inferno", begin = .1, end = .7) +
 guides(alpha=guide_legend(ncol = 2), fill=guide_legend(ncol = 2)) +
 theme_void() +
 theme(legend.position = "inside", legend.position.inside = c(0.1, 0.9))

p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE)

# Add labels to external donut as percent inside group
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE) +
 geom_label_ext(aes(label=paste0(lvl2, ": {scales::percent(.prc_grp)}")),
                show.legend = FALSE, size=3, col="white")

# Leverage ggplot2 feature for labels
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = TRUE) +
 geom_label_ext(aes(label=paste0(lvl2, ": {scales::percent(.prc)}")),
                show.legend = FALSE, size=3, col="white", angle=90,
                layout = circle())

# Leverage another layout
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE) +
 geom_label_ext(aes(label=paste0(lvl2, ": {scales::percent(.prc_grp)}")),
                show.legend = FALSE, size=3, col="white",
                layout = tv(thinner = TRUE, thinner_gap = 0.15))

}
\seealso{
\link{layouts}, \link{pins}
}
\keyword{datasets}
