% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pins.R
\docType{data}
\name{pins}
\alias{pins}
\alias{StatPinLine}
\alias{geom_pin_line}
\alias{StatPinHead}
\alias{geom_pin_head}
\alias{geom_pin}
\title{Connecting labels with donut segments}
\format{
An object of class \code{StatPinLine} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatPinHead} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
geom_pin_line(
  mapping = NULL,
  data = NULL,
  stat = "pin",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r = 1.5,
  cut = 0.1,
  layout = circle(),
  ...
)

geom_pin_head(
  mapping = NULL,
  data = NULL,
  stat = "point",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r = 1.5,
  cut = 0.1,
  layout = circle(),
  ...
)

geom_pin(..., head = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{r}{The radius where donut is placed}

\item{cut}{Sets additional two-sided gap for pins}

\item{layout}{The layout function to effectively display text and labels.
Obviously it's better to have the same as for \code{geom_label_ext} or \code{geom_text_ext}}

\item{...}{Parameters to be passed to \code{geom_pin_line()} and \code{geom_pin_head()}}

\item{head}{Boolean - defines whether to add pin head}
}
\value{
None
}
\description{
The set of functions served to connect text or labels with donut segments
\itemize{
\item \code{geom_pin_line()} - builds curved line to linl label with donut segment
\item \code{geom_pin_head()} - builds stylish point heads for pins
\item \code{geom_pin()} - handy wrapper for \code{geom_pin_line()} and \code{geom_pin_head()}
}
}
\examples{
n <- 30
set.seed(2021)
df <- dplyr::tibble(
  lvl1 = sample(LETTERS[1:5], n, TRUE),
  lvl2 = sample(LETTERS[6:24], n, TRUE),
  value = sample(1:20, n, TRUE),
  highlight_ext = sample(c(FALSE,TRUE), n, TRUE, c(.9, .1))) |>
  dplyr::mutate(highlight_int = dplyr::if_else(lvl1 == "A", TRUE, FALSE))

# Starting plot with doubled donuts and annotations for internal one
p <- dplyr::group_by(df, lvl1, lvl2, highlight_ext, highlight_int) |>
  dplyr::summarise(value = sum(value), .groups = "drop") |>
  packing(value, lvl1) |>
  ggplot(aes(value = value, fill = lvl1)) +
  geom_donut_int(aes(highlight = highlight_int), alpha=.5, r_int = .25) +
  geom_label_int(aes(label = "Sum {fill}:\n{.sum}-{scales::percent(.prc)}"),
                 alpha = .6, col = "white", size = 3, r=1.2) +
  geom_donut_ext(aes(opacity = lvl2, highlight = highlight_ext)) +
  scale_fill_viridis_d(option = "inferno", begin = .1, end = .7) +
  guides(alpha = guide_legend(ncol = 2), fill = guide_legend(ncol = 2)) +
  theme_void() +
  theme(legend.position = "none")

p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE)

# Add labels to external donut as percent inside group
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE) +
  geom_label_ext(aes(label = paste0(lvl2, ": {scales::percent(.prc_grp)}")),
                 show.legend = FALSE, size=3, col="white") +
  geom_pin(size = .5, linewidth=.1, show.legend = FALSE, cut = .2)

# Leverage tv() layout
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE) +
  geom_label_ext(aes(label = paste0(lvl2, ":{scales::percent(.prc_grp)}")),
                 show.legend = FALSE, size=3, col="white",
                 layout = tv(thinner = TRUE, thinner_gap = .15)) +
  geom_pin(size = .5, linewidth=.1, show.legend = FALSE, cut = .2,
           layout = tv(thinner = TRUE, thinner_gap = .15))

# Leverage another layout
p + coord_radial(theta = "y", expand = FALSE, rotate_angle = FALSE) +
  geom_label_ext(aes(label = paste0(lvl2, ": {scales::percent(.prc_grp)}")),
                 show.legend = FALSE, size=3, col="white", layout = eye()) +
  geom_pin(size = .5, linewidth=.1, show.legend = FALSE, layout = eye())

}
\seealso{
\link{layouts}, \link{donut_label}
}
\keyword{datasets}
