% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{plot.doremidata}
\alias{plot.doremidata}
\title{S3 method to plot DOREMIDATA objects}
\usage{
\method{plot}{doremidata}(x, ...)
}
\arguments{
\item{x}{DOREMIDATA object resulting from the aforementioned functions}

\item{...}{includes the additional arguments inherited from the generic plot method}
}
\value{
Returns a plot with axis labels, legend and title. The title includes the name of the DOREMIDATA object result of the analysis.
The function uses \code{\link[ggplot2]{ggplot}}
to generate the graphs and thus it is possible to override the values of axis labels, legend and title through ggplot commands.
}
\description{
\code{plot.doremidata} generates a plot of the simulated signals resulting from the \code{\link{generate.panel.1order}} and \code{\link{generate.panel.2order}} functions
}
\examples{
mydata <- generate.panel.1order(time=0:100,
                                excitation = c(rep(0,50),rep(1,51)),
                                nind = 6,
                                internoise = 0.2,
                                intranoise = 100)
plot(mydata)
}
