% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpkg_tibble.R
\name{as_dpkg}
\alias{as_dpkg}
\title{Use a data.frame and metadata to create a data package}
\usage{
as_dpkg(
  x,
  name = deparse(substitute(x)),
  version = "0.0.0.9000",
  title = character(),
  homepage = character(),
  description = character()
)
}
\arguments{
\item{x}{a tibble or data frame}

\item{name}{a lowercase character string consisting of only
\code{a-z}, \code{0-9}, \code{-}, \verb{_}, or \code{.} to be used as a data package identifier}

\item{version}{a character string representing a
\href{https://datapackage.org/recipes/data-package-version/}{semantic version} (e.g., "0.2.1")}

\item{title}{a character string that is a title of the data package for humans}

\item{homepage}{a valid URL that links to a webpage with code or descriptions related to creation of the data package}

\item{description}{a character string (markdown encouraged!) of more details
about how the data was created, including the data sources,
references to code or packages used, relevant details for any
specific columns, and notes about (mis)usage of the data}
}
\value{
a dpkg object
}
\description{
Convert a data frame into a data package (\code{dpkg}) by providing specific metadata in the arguments.
}
\details{
\code{name} should be specified, but if is not will be deparsed from code defining \code{x};
this might not result in a valid \code{name} (e.g., when piping code to create a data frame)
}
\examples{

x <- as_dpkg(mtcars, name = "mtcars", title = "Motor Trend Road Car Tests")
attr(x, "description") <- "This is a data set all about characteristics of different cars"
attr(x, "homepage") <- "https://github.com/cole-brokamp/dpkg"
x
}
