% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old.R
\name{dpseg_old}
\alias{dpseg_old}
\title{inefficient \code{\link{dpseg}} implementation}
\usage{
dpseg_old(x, y, minl, maxl = length(x), P = 0, EPS,
  store.matrix = FALSE, fitscoref = fitscore, fitf = linregf,
  scoref = varscore, verb = 0)
}
\arguments{
\item{x}{x-values}

\item{y}{y-values}

\item{minl}{minimal segment length}

\item{maxl}{maximal segment length}

\item{P}{jump penalty, increase to get fewer segments #
@inheritParams score}

\item{EPS}{a pre-calculated fitscore matrix, will be generated if
missing}

\item{store.matrix}{store the fitscore matrix}

\item{fitscoref}{the heavy-load loop that fills the fitscore matrix
using \code{fitf} and \code{scoref}}

\item{fitf}{fit function, used in the scoring function
\code{scoref}; (TODO: currently expecting a fit object that
provides intercept and slope as \code{coef(obj)[1:2]} only for
the result table)}

\item{scoref}{function to calculate a score from the passed fit
function}

\item{verb}{print progress messages}
}
\value{
Returns a list of result structures very similar to the
    list of class "dpseg" returned by function \code{\link{dpseg}},
    except for the name of the scoring function matrix, here:
    \code{EPS}. See \code{?dpseg} for detailed information on these
    structures.
}
\description{
See  \code{\link{dpseg}} for a current version of this algorithm.
Note: this was a first test implementation of the linear
piecewise segmentation by a dynamic programming approach.
This implementation is very slow. A much more efficient
version, \code{\link{dpseg}}, calculates the variance of residuals of a
linear regression incrementally while looping through the recursion, and
is implemented in \code{Rcpp}.
See there for details on the algorithm.
This version is kept alive, since it is a more general implementation,
allowing to test different regression and scoring functions by
command-line arguments.
}
\details{
The recursion calculates \eqn{S_j = max ( S_i +
fitscore(i+1,j)) - P}, where the fitscore is the variance of the
residuals of a linear regression (\code{lm(y~x})) between
\eqn{x_{i+1}} to \eqn{x_j}, \code{P} is a jump penality that
implicitly regulates the number of segments, \code{minl} and
\code{maxl} are minimal and maximal lengths of segments. Uses
\code{\link[RcppEigen:fastLm]{RcppEigen:fastLm}} for linear
regression.
}
\examples{
\donttest{

## NOTE: not run because it's too slow for R CMD check --as-cran
## calculate linear segments in semi-log bacterial growth data
## NOTE: library loads bacterial growth curve data as data.frame oddata
Sj <- dpseg_old(x=oddata$Time, y=log(oddata$A3), minl=5, P=0.0001, verb=1)

## inspect resulting segments
print(Sj)

## plot results
plot(Sj, delog=TRUE, log="y")

## NOTE: predict method & movie function do not work for dpseg_old
}
}
