% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dose_draw.R
\name{f_dose_draw}
\alias{f_dose_draw}
\title{Drug Dispensing Data Simulation}
\usage{
f_dose_draw(
  vf_ongoing,
  vf_new,
  common_time_model,
  k0_fit,
  t0_fit,
  t1_fit,
  ki_fit,
  ti_fit,
  di_fit,
  t0,
  t,
  ncores_max
)
}
\arguments{
\item{vf_ongoing}{A data frame for the observed drug dispensing
data for ongoing patients with drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{day}, \code{dose}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, and \code{totalTime}.}

\item{vf_new}{A data frame for the randomization date for new
patients and ongoing patients with no drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{arrivalTime}, \code{treatment}, \code{treatment_description},
\code{time}, and \code{totalTime}.}

\item{common_time_model}{A Boolean variable that indicates whether
a common time model is used for drug dispensing visits.}

\item{k0_fit}{The model fit for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{t0_fit}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{t1_fit}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is visit skipping.}

\item{ki_fit}{The model fit for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{ti_fit}{The model fit for the gap time between two
consecutive drug dispensing visits.}

\item{di_fit}{The model fit for the dispensed doses at drug
dispensing visits.}

\item{t0}{The cutoff date relative to the trial start date.}

\item{t}{A vector of new time points for drug dispensing prediction.}

\item{ncores_max}{The maximum number of cores to use for parallel
computing. The actual number of cores used is the minimum of
\code{ncores_max} and half of the detected number of cores.}
}
\value{
A list with two components:
\itemize{
\item \code{dosing_subject_new}: A data frame containing observed and
imputed subject-level dosing records for ongoing and new patients
for the first iteration. It contains the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{day}, \code{dose}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, and \code{totalTime}.
\item \code{dosing_summary_new}: A data frame providing dosing summaries
by drug, future time point, and simulation draw for ongoing
and new patients. It contains the following variables:
\code{kit}, \code{kit_name}, \code{t}, \code{draw}, and
\code{total_dose_b}.
}
}
\description{
Simulates drug dispensing data after cutoff for
both ongoing and new patients.
}
\examples{

\donttest{
set.seed(431)
library(dplyr)

pred <- eventPred::getPrediction(
  df = df2,
  to_predict = "event only",
  target_d = 250,
  event_model = "log-logistic",
  dropout_model = "none",
  pilevel = 0.95,
  nyears = 3,
  nreps = 200,
  showsummary = FALSE,
  showplot = FALSE,
  by_treatment = TRUE)

observed <- f_dose_observed(df2, visitview2, showplot = FALSE)

fit <- f_dispensing_models(
  observed$vf, dosing_schedule_df,
  model_k0 = "zero-inflated poisson",
  model_t0 = "log-logistic",
  model_t1 = "least squares",
  model_ki = "zero-inflated poisson",
  model_ti = "least squares",
  model_di = "linear mixed-effects model",
  nreps = 200, showplot = FALSE)

trialsdt = df2$trialsdt[1]
cutoffdt = df2$cutoffdt[1]
t0 = as.numeric(cutoffdt - trialsdt + 1)
nyears = 3
t1 = t0 + nyears*365
t = c(seq(t0, t1, 30), t1)

vf_ongoing_new <- f_ongoing_new(
  pred$event_pred$newEvents,
  observed$kit_description_df,
  observed$treatment_by_drug_df,
  observed$vf)

dose_draw <- f_dose_draw(
  vf_ongoing_new$vf_ongoing,
  vf_ongoing_new$vf_new,
  fit$common_time_model,
  fit$k0_fit, fit$t0_fit, fit$t1_fit,
  fit$ki_fit, fit$ti_fit, fit$di_fit,
  t0, t, ncores_max = 2)

head(dose_draw$dosing_subject_new)
head(dose_draw$dosing_summary_new)
}

}
\seealso{
\code{\link{f_fit_t0}}, \code{\link{f_fit_ki}},
\code{\link{f_fit_ti}}, \code{\link{f_fit_di}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
