% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_t0}
\alias{f_fit_t0}
\title{Model Fitting for Dispensing Delay After Randomization}
\usage{
f_fit_t0(df, model, nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including the following
variables:
\itemize{
\item \code{time}: The number of days between randomization and the
first drug dispensing visit (first drug dispensing visit date -
randomization date + 1).
\item \code{left}: Equals \code{time - 1}, used to indicate the
left endpoint of an interval for interval censoring.
\item \code{right}: Equals \code{time}, used to indicate the
right endpoint of an interval for interval censoring.
}}

\item{model}{The event model used to analyze the gap time
between randomization and the first drug dispensing visit when
there is no visit skipping, with options including "constant",
"exponential", "weibull", "log-logistic", and "log-normal".}

\item{nreps}{The number of simulations for drawing posterior model
parameter values.}

\item{showplot}{A Boolean variable that controls whether or not to
show the fitted time-to-event bar chart. It defaults to \code{TRUE}.}
}
\value{
A list with three components:
\itemize{
\item \code{fit}: A list of results from the model fit that includes
\itemize{
\item \code{model}: The specific model used in the analysis.
\item \code{theta}: The estimated model parameters.
\item \code{vtheta}: The estimated covariance matrix of \code{theta}.
\item \code{aic}: The Akaike Information Criterion value.
\item \code{bic}: The Bayesian Information Criterion value.
}
\item \code{fit_plot}: A fitted time-to-event bar chart.
\item \code{theta}: Posterior draws of model parameters.
}
}
\description{
Fits a specified time-to-event model to the gap time
between randomization and the first drug dispensing visit when
there is no visit skipping.
}
\examples{
library(dplyr)

observed <- f_dose_observed(df2, visitview2, showplot = FALSE)
vf <- observed$vf

vf <- vf \%>\% left_join(dosing_schedule_df, by = "kit")

# time from randomization to the first drug dispensing visit
df_k0 <- vf \%>\%
  filter(row_id == 1) \%>\%
  mutate(time = day,
         skipped = floor((time - target_days/2)/target_days) + 1)

# no skipping
df_t0 <- df_k0 \%>\%
  filter(skipped == 0) \%>\%
  mutate(left = time - 1, right = time)

t0_fit <- f_fit_t0(df_t0, model = "log-logistic", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
