% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsa.R
\name{dsa}
\alias{dsa}
\title{Seasonally Adjust Daily Time Series}
\usage{
dsa(
  series,
  span.start = NULL,
  model = NULL,
  Log = FALSE,
  automodel = "reduced",
  ic = "bic",
  include.constant = FALSE,
  fourier_number = 24,
  max_fourier = 30,
  s.window1 = 53,
  s.window2 = 53,
  s.window3 = 13,
  t.window1 = NULL,
  t.window2 = NULL,
  t.window3 = NULL,
  cval = 7,
  robust1 = TRUE,
  robust2 = TRUE,
  robust3 = TRUE,
  regressor = NULL,
  forecast_regressor = NULL,
  reg_create = NULL,
  reg_dummy = NULL,
  outlier = TRUE,
  outlier_types = c("AO", "LS", "TC"),
  delta = 0.7,
  model_span = NULL,
  feb29 = "sfac",
  trend_month = 3,
  outer3 = NULL,
  inner3 = NULL,
  h = 365,
  reiterate3 = NULL,
  scaler = 1e+07,
  mean_correction = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{series}{Input time series in xts format}

\item{span.start}{Define when seasonal adjustment should begin}

\item{model}{ARIMA order of non-seasonal part}

\item{Log}{Boolean. Should multiplicate or additive model be used}

\item{automodel}{Set of models to be considered for automatic model detection. Either "full" or "reduced" set of fourier regressors included}

\item{ic}{Information criterion that is used for automodelling. One of "bic", "aic" or "aicc"}

\item{include.constant}{Should drift be allowed for model that includes differencing}

\item{fourier_number}{Number of trigometric regressors to model annual and monthly seasonality}

\item{max_fourier}{Maximum number of trigonometric regressors allowed if the number is selected automatically, i.e. fourier_number=NULL}

\item{s.window1}{STL parameter s.window for the day of the week effect}

\item{s.window2}{STL parameter s.window for the day of the month effect}

\item{s.window3}{STL parameter s.window for the day of the year effect}

\item{t.window1}{STL parameter t.window for the day of the week effect}

\item{t.window2}{STL parameter t.window for the day of the month effect}

\item{t.window3}{STL parameter t.window for the day of the year effect}

\item{cval}{Critical value for outlier adjustment}

\item{robust1}{Boolean. Should robust STL be used for the day of the week effect}

\item{robust2}{Boolean. Should robust STL be used for the day of the month effect}

\item{robust3}{Boolean. Should robust STL be used for the day of the year effect}

\item{regressor}{Pre-specified regressors}

\item{forecast_regressor}{Pre-specified regressors to be used for forecasting}

\item{reg_create}{Names of Holidays for which regressors will be created}

\item{reg_dummy}{If specified dummy variables of specified length are created and used as regressors}

\item{outlier}{Should an outlier adjustment be conducted?}

\item{outlier_types}{The following are possible: "LS", "TC", "AO", "IO"}

\item{delta}{The decay rate for TC outliers}

\item{model_span}{Last x years used for regARIMA modelling}

\item{feb29}{How should February 29th be derived: interpolation of adjusted series ("sa") or combined factor ("sfac")}

\item{trend_month}{Length of support period for trend estimation}

\item{outer3}{Number of iterations of outer loop in STL for day of the year effect}

\item{inner3}{Number of iterations of inner loop in STL for day of the year effect}

\item{h}{Forecast horizon in number of days}

\item{reiterate3}{Number of total iterations of STL for the day of the year effect}

\item{scaler}{for additive model, if max(abs(series)) > 1e5, scale series}

\item{mean_correction}{Boolean. Should seasonal factors be standardised so that their mean (over all full cycles) is 0 for additive and 1 for multiplicative models}

\item{progress_bar}{Boolean. Should a progress bar be displayed}
}
\value{
\code{dsa} returns a \code{daily} object which contains the output of the seasonal adjustment of a daily time series.

{output} {Contains the calendar and seasonally adjusted series, original series, implicit calendar and seasonal component, and Loess based trend as an \code{xts} object}

{fourier_terms} {The number of sine and cosine terms used to model the seasonal pattern in the RegARIMA model}

{reg} {RegARIMA results}

{info} {Basic information on transformation (Log/Level), differencing and forecast horizon}

{stl} {A list of length 3, containing the STL results of the day-of-week, day-of-the-month and day-of-the-year adjustment, respectively}

{outlier} {Result of the outlier adjustment}

{sa_result} {The original series and the intermediate adjustment results after the day-of-week adjustment (s1_adjusted), calendar adjustment (s1k1_adjusted), day-of-the-month adjustment (s1k1s2_adjusted), and the final adjusted series after the day-of-the-year adjustment (seas_adj) as an \code{xts} object}

{sa_result2} {The original series only adjusted for single components as an \code{xts} object. Namely the original series itself (original), the original only adjusted for the day-of-the week (s1_adjusted), calendar (k1_adjusted), day-of-the-month (s2_adjusted), and day-of-the-year (s3_adjusted)}

{sfac_result} {The seasonal and calendar components as an \code{xts} object. Namely, the day-of-the-week (s1_fac), calendar (cal_fac), day-of-the-month (s2_fac), and day-of-the-year component (s3_fac) }
}
\description{
Seasonally adjust daily time series using the dsa approach
}
\details{
This function can be used to seasonally and calendar adjust daily time series and decomposing the series into a seasonally adjusted series, a day-of-the-week, a moving holiday, a day-of-the-month and a day-of-the-year component.

If mean_correction=TRUE (default), the seasonal and calendar factors are corrected, so that over all full years, the mean of the components is 0 in additive models. They will be close to 1 if a multiplicative decomposition (i.e. Log=TRUE) is used. Deviations from 1 may result, because the mean correction is applied to the components before inverting taking logs.

For long series, the ARIMA modelling and the outlier adjustment may take a long time. It may therefore be a good idea, to specify the ARIMA model used, e.g. model=c(3,1,0). If the series does not contain influential outliers, the outlier adjustment could be skipped by setting outlier=FALSE.

See vignette for further examples.
}
\examples{
x = daily_sim(n=4)$original # series with length 4 years
res <- dsa(x, cval=7, model=c(3,1,0),fourier_number = 13)
}
\references{
Ollech, Daniel (2018). Seasonal adjustment of daily time series. Bundesbank Discussion Paper 41/2018.

Ollech, Daniel (2021). Seasonal Adjustment of Daily Time Series. Journal of Time Series Econometrics (forthcoming).
}
\author{
Daniel Ollech
}
