% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericFunctions.R
\name{plot.daily}
\alias{plot.daily}
\title{Plot daily time series}
\usage{
\method{plot}{daily}(x, dy = TRUE, trend = FALSE, ...)
}
\arguments{
\item{x}{Result of dsa() that will be plotted}

\item{dy}{should dygraphs be used for plotting}

\item{trend}{Boolean. Inclusion of a trend estimate.}

\item{...}{Other plot parameters (only if dy=FALSE)}
}
\description{
Plotting output for objects of class "daily"
}
\details{
The original series is plotted in black, the seasonally adjusted series is colored in red, and if trend=T, a blue trend line is added.
}
\examples{
x <- daily_sim(3)$original
\dontrun{res<- dsa(x, fourier_number = 24, outlier.types="AO", reg.create=NULL, model=c(3,1,0))}
\dontrun{plot(res, dy=FALSE)}
}
\author{
Daniel Ollech
}
