% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{estimate.gaussmodel}
\alias{estimate.gaussmodel}
\title{Estimate Gaussian-based model \code{gaussmodel}}
\usage{
\method{estimate}{gaussmodel}(
  model,
  deglist = deglist,
  mulist = mulist,
  sdlist = sdlist,
  scaling = FALSE,
  recompute = FALSE,
  stepsize = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{An object of a \code{gaussmodel} class.}

\item{deglist}{A vector of degrees of polynomials. The element should be
positive even numbers.}

\item{mulist}{A vector of means for Gaussian-based models.}

\item{sdlist}{A vector of standard deviations for Gaussian-based models.
The element should be larger than 0.}

\item{scaling}{A logical scalar, which indicates whether or not it scales
means and standard deviations in \code{mulist} and \code{sdlist}.
The default value is \code{FALSE}.}

\item{recompute}{If \code{TRUE}, recomputes the results for better
estimation and accuracy. Parameters whose accuracies had been already
attained sufficiently, namely around 1.0e-6, are not included in candidates
for recomputing.}

\item{stepsize}{A vector in descending order whose values are
between 0 and 1.
If a small step size is supplied, it can attain successful estimates,
but it might take more iterations.}

\item{verbose}{If \code{TRUE}, it shows the detailed message of SDP solver.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A \code{gaussmodel} object including the estimates.
Those estimates are stored in \code{model$result} with
\code{data.frame} format and \code{model$coeffs} in \code{list} format.
}
\description{
Estimates Gaussian-based model \code{gaussmodel} among
parameter vectors, \code{deglist}, \code{mulist}, \code{sdlist}.
Then it sorts the results by AIC.
}
\examples{
## Create an `gaussmodel` object
gmodel <- gaussmodel(mix2gauss$n200)
## Estimate a model with parameters
gmodel <- estimate(gmodel, deglist=c(2, 4), mulist=c(0.0, 0.2),
             sdlist=c(0.75, 1.0))
}
\seealso{
\code{\link[=gaussmodel]{gaussmodel()}} \code{\link[=summary.gaussmodel]{summary.gaussmodel()}} \code{\link[=plot.gaussmodel]{plot.gaussmodel()}}
}
