% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{t_sampleBTF}
\alias{t_sampleBTF}
\title{Sampler for first or second order random walk (RW) Gaussian dynamic linear model (DLM)}
\usage{
t_sampleBTF(y, obs_sigma_t2, evol_sigma_t2, D = 1, loc_obs)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x 1} vector of evolution error variances}

\item{D}{the degree of differencing (one or two)}

\item{loc_obs}{list of the row and column indices to fill in a band-sparse matrix}
}
\value{
\code{T x 1} vector of simulated states
}
\description{
Compute one draw of the \code{T} state variable \code{mu} in a DLM using back-band substitution methods.
This model is equivalent to the Bayesian trend filtering (BTF) model, assuming appropriate
(shrinkage/sparsity) priors for the evolution errors.
}
\note{
Missing entries (NAs) are not permitted in \code{y}. Imputation schemes are available.
}
