% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtangle2.R
\name{dtangle2}
\alias{dtangle2}
\title{Deconvolve cell type mixing proportions from gene expression data.}
\usage{
dtangle2(Y, references = NULL, pure_samples = NULL, n_markers = NULL,
  markers = NULL, marker_method = "ratio", weights = NULL,
  sto = TRUE, inv_scale = function(x) 2^x, fit_scale = log,
  loss_smry = "var", dtangle_init = TRUE, seed = NULL,
  verbose = FALSE, optim_opts = NULL)
}
\arguments{
\item{Y}{Expression matrix.

(Required) Two-dimensional numeric. Must implement \code{as.matrix}.

Each row contains expression measurements for a particular sample. Each columm contains the measurements of the same gene over all individuals. Can either contain just the mixture samples to be deconvolved or both the mixture samples and the reference samples. See \code{pure_samples} and \code{references} for more details.}

\item{references}{Cell-type reference expression matrix.

(Optional) Two-dimensional numeric. Must implement \code{as.matrix}. Must have same number of columns as \code{Y}. Columns must correspond to columns of \code{Y}.

Each row contains expression measurements for a reference profile of a particular cell type. Columns contain measurements of reference profiles of a gene. Optionally may merge this matrix with \code{Y} and use \code{pure_samples} to indicate which rows of \code{Y} are pure samples. If \code{pure_samples} is not specified \code{references} must be specified. In this case each row of \code{references} is assumed to be a distinct cell-type. If both \code{pure_samples} and \code{references} are specified then \code{pure_samples} specifies to which cell-type each row of \code{references} corresponds.}

\item{pure_samples}{The pure sample indicies.

(Optional) List of one-dimensional integer. Must implement \code{as.list}.

The i-th element of the top-level list is a vector of indicies (rows of \code{Y} or \code{references}) that are pure samples of type i. If \code{references} is not specified then this argument identifies which rows of \code{Y} correspond to pure reference samples of which cell-types. If \code{references} is specified then this makes same idenficiation but for the \code{references} matrix instead.}

\item{n_markers}{Number of marker genes.

(Optional) One-dimensional numeric.

How many markers genes to use for deconvolution. Can either be a single integer, vector of integers (one for each cell type), or single or vector of percentages (numeric in 0 to 1). If a single integer then all cell types use that number of markers. If a vector then the i-th element determines how many marker genes are used for the i-th cell type. If single percentage (in 0 to 1) then that percentage of markers are used for all types. If vector of percentages then that percentage used for each type, respectively. If not specified then top 10\% of genes are used.}

\item{markers}{Marker gene indices.

(Optional) List of one-dimensional integer.

Top-level list should be same length as \code{pure_samples}, i.e. one element for each cell type. Each element of the top-level list is a vector of indicies (columns of \code{Y}) that will be considered markers of that particular type. If not supplied then \code{dtangle} finds markers internally using \code{find_markers}. Alternatively, one can supply the output of \code{find_markers} to the markers argument.}

\item{marker_method}{Method used to rank marker genes.

(Optional) One-dimensional string.

The method used to rank genes as markers. If not supplied defaults to ``ratio''. Only used if markers are not provided to argument ``markers''. Options are
\itemize{
\item{'ratio'}{ selects and ranks markers by the ratio of the mean expression of each gene in each cell type to the mean of that gene in all other cell types.}
\item{'regression '}{ selects and ranks markers by estimated regression coefficients in a series of regressions with single covariate that is indicator of each type.}
\item{'diff'}{ selects and ranks markers based upon the difference, for each cell type, between the median expression of a gene by each cell type and the median expression of that gene by the second most highly expressed cell type.}
\item{'p.value'}{ selects and ranks markers based upon the p-value of a t-test between the median expression of a gene by each cell type and the median expression of that gene by the second most highly expressed cell type.}
}}

\item{weights}{Weights for the genes.

(Optional) String or one-dimensional numeric vector. 

Weights for the genes in the optimization. If NULL (default) then does not weight genes differently. If 'variance' then inversely weights with the variance of the references. This only works if there is more than one reference per cell type so that the variance can be estimated. If a numeric then this uses whatever is specified as weights. They must be non-negative.}

\item{sto}{Sum-to-one constraint.

(Optional) Boolean.

Re-normalize the estimates so that the cell-type proportions sum to one.}

\item{inv_scale}{Inverse scale transformation.

(Optional) Function. 

Defaults to 2^x. This is equivalent to assuming that the data has been log2-transformed. If another transformation has been applied to the data then this function should be used to specify the inverse of that transformation needed to put gene expressions on the linear scale.}

\item{fit_scale}{Transformation to used as part of optimization.

(Optional) Function.

Function to apply to gene expressions as part of optimization. Defaults to log.}

\item{loss_smry}{Loss summary function minimized to find estimated proportions.

(Optional) String.

Either 'var' (default) to minimze the (weighted) variance of the residuals or 'L2' to minimize the (weighted) sums of squares of the residuals.}

\item{dtangle_init}{Optimization initialization.

(Optional) Boolean.

Boolean controlling if dtangle2 optimization should be initialized using dtangle1 estimates.}

\item{seed}{(Optional) Integer.

Value at which to seed the random seed before estimating. Optimization initialization might change if this value is not specified.}

\item{verbose}{(Optional) Boolean.

Controls if optimization output is printed or not.}

\item{optim_opts}{(Optional) List.

Optimization options passed to DEoptimR controlling optimization. Options that may be set are
\itemize{
\item{'constr'} constraint to enforce. Either 'box' for 0-1 box constraints that proportions are between zero and one, 'ineq' for constraints that proportions sum to less than one, 'eq' for equality constraints that proportions sum to one, or 'eq_solve' to solve for one of the parameters in terms of the other and enfoce equality constraints using inequality on remaining parameters. Default and recommended is 'box'.
\item{'ninit'} number of randomly initalized points as part of the DEoptimR initial population.
\item{'tritter'} how often to print results if 'verbose=TRUE'.
\item{'maxiter'} maximum number of optimization iterations to use before exiting.
\item{'convtol'} tolerance for convergence tolerance stopping criterion. 
\item{'constrtol'} tolerance for constraint enforcement.
}}
}
\value{
List.
\itemize{
\item{'estimates'}{ a matrix estimated mixing proportions. One row for each sample, one column for each cell type.}
\item{'markers'}{ list of vectors of marker used for each cell type. Each element of list is vector of columns of \code{Y} used as a marker for the i-th cell type.}
\item{'n_markers'}{ vector of number of markers used for each cell type.}
\item{'weights'}{ the weights used as part of the optimization.}
\item{'diag'}{ diagnostic values for the estimated proportions.
\code{resids_hat},\code{loss_hat}, and \code{p_hat} are the residuals, loss, and estimates for the proportions returned by dtangle2. Similarly, \code{resids_opt},\code{loss_opt} and \code{p_opt} are these values for the optimized value not re-scaled to enforce the STO constraint. 
}
}
}
\description{
Deconvolve cell type mixing proportions from gene expression data.
}
\examples{
\donttest{
truth = shen_orr_ex$annotation$mixture
pure_samples <- lapply(1:3, function(i) {
   which(truth[, i] == 1)
})
Y <- shen_orr_ex$data$log
n_markers = 20

dtangle2(Y, pure_samples = pure_samples,
n_markers=n_markers)
}

}
\seealso{
\code{\link{find_markers}}
}
