% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{make_dua_template}
\alias{make_dua_template}
\title{Interactive function to create template file}
\usage{
make_dua_template(file_name, include_notes = TRUE, answer_list = NULL)
}
\arguments{
\item{file_name}{Name with path of template script.}

\item{include_notes}{If \code{TRUE}, the template file will include
notes and suggestions for completing the script; default value
is \code{TRUE}.}

\item{answer_list}{List of answer strings to provide if you don't
want to answer questions interactively. See details for
questions and expected input type. Leave as default \code{NULL}
for interactive mode.}
}
\description{
Use this function to create a template script that puts package
functions in order and, based on question answers, prepopulates
some arguments.  By default, this function is run in interactive
mode, meaning that it will not work in a script unless a list of
answers is given to \code{answer_list} argument.  Note that the
saved template file is not intended to be run as is, but only to
provide a starting structure for a cleaning script.
}
\details{
Questions to answer if using the \code{answer_list} argument:

\enumerate{
\item Do you want to set the DUA crosswalk file? \code{'Yes'} or \code{'No'}
\enumerate{
\item DUA crosswalk file (with path): '< file name with path >'
}
\item Do the data need to be deidentified? \code{'Yes'} or \code{'No'}
\enumerate{
\item Would like to select the ID column now? \code{'Yes'} or \code{'No'}
\item ID column name: '< column name string >'
}
}

If answers to questions (1) and (2) are \code{No}, then strings for 1(a),
2(a), and 2(b) can be left empty since they will be ignored.
}
\examples{
\dontrun{
## run interactively
make_dua_template('data_clean.R')

## ...and don't include extra notes
make_dua_template('data_clean.R', include_notes = FALSE)
}

## make template to be filled in
file <- file.path(tempdir(), 'data_clean.R')
make_dua_template(file, answer_list = list('No','','No','',''))

## show
writeLines(readLines(file))

}
