% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_plot_openpose.R
\name{op_plot_openpose}
\alias{op_plot_openpose}
\title{Plot OpenPose Data for a Specified Frame}
\usage{
op_plot_openpose(
  data,
  frame_num,
  person = c("both", "left", "right"),
  lines = TRUE,
  keylabels = FALSE,
  label_type = c("names", "numbers"),
  hide_labels = FALSE,
  left_color = "blue",
  right_color = "red",
  background_color = "white",
  background_colour = NULL,
  line_width = 2,
  point_size = 1.5,
  text_color = "black"
)
}
\arguments{
\item{data}{A data frame containing OpenPose data. The data frame should include columns for the frame number,
person identifier, and x/y coordinates for each keypoint.}

\item{frame_num}{A numeric value specifying the frame number to plot.}

\item{person}{A character string specifying which person to plot: "left", "right", or "both". Default is "both".}

\item{lines}{A logical value indicating whether to draw lines between keypoints. Default is TRUE.}

\item{keylabels}{A logical value indicating whether to display keypoint labels. Default is FALSE.}

\item{label_type}{A character string specifying the type of labels to display: "names" or "numbers". Default is "names".}

\item{hide_labels}{A logical value indicating whether to hide axis labels and plot titles. Default is FALSE.}

\item{left_color}{A character string specifying the color for the left person. Default is "blue".}

\item{right_color}{A character string specifying the color for the right person. Default is "red".}

\item{background_color}{A character string specifying the background color of the plot. Default is "white".}

\item{background_colour}{A character string specifying the background colour of the plot (UK spelling). Default is NULL.}

\item{line_width}{A numeric value specifying the width of the lines between keypoints. Default is 2.}

\item{point_size}{A numeric value specifying the size of the keypoint markers. Default is 1.5.}

\item{text_color}{A character string specifying the color of the text (labels and titles). Default is "black".}
}
\value{
No return value, called for side effects (plotting to screen).
}
\description{
This function visualizes keypoints and their connections from OpenPose data for a specified frame.
The function allows customization of the plot, including the option to display labels, lines between keypoints,
and different colours for left and right persons.
}
\examples{
# Path to example CSV file included with the package
file_path <- system.file("extdata/csv_data/A-B_body_dyad.csv", package = "duet")

# Load the data
data <- read.csv(file_path)

# Plot the data for the specified frame
op_plot_openpose(
  data = data,
  frame_num = 1,
  person = "both",
  lines = TRUE,
  keylabels = TRUE,
  label_type = "names",
  left_color = "blue",
  right_color = "red",
  background_colour = "grey90"
)

}
