% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleancut.R
\name{cleancut}
\alias{cleancut}
\title{Convert Numeric to Factor with Convenient Interface}
\usage{
cleancut(x, breaks, labels = NULL)
}
\arguments{
\item{x}{Numeric vector.}

\item{breaks}{Character string, e.g. \code{"[-Inf, 0), [0, 10], (10, Inf)"}.}

\item{labels}{Character vector.}
}
\value{
Factor or integer vector.
}
\description{
So you can stop guess-and-checking with \code{\link{cut}}.
}
\examples{
x <- rnorm(100)
y <- cleancut(x, "(-Inf, -1), [-1, 1], (1, Inf)")
tapply(x, y, range)

y <- cleancut(x, "(-Inf, -1), [-1, 1], (1, Inf)", c("<-1", "-1 to 1", ">1"))
tapply(x, y, range)

}
