% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_linear_trajectory.R
\name{add_linear_trajectory}
\alias{add_linear_trajectory}
\title{Constructs a linear trajectory using pseudotime values}
\usage{
add_linear_trajectory(
  dataset,
  pseudotime,
  directed = FALSE,
  do_scale_minmax = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{pseudotime}{A named vector of pseudo times.}

\item{directed}{Whether the trajectory will be directed.}

\item{do_scale_minmax}{Whether or not to scale the pseudotime between 0 and 1.
Otherwise, will assume the values are already within that range.}

\item{...}{extra information to be stored in the trajectory}
}
\value{
A trajectory object
}
\description{
Constructs a linear trajectory using pseudotime values
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

pseudotime <- tibble(
  cell_id = dataset$cell_ids,
  pseudotime = runif(length(dataset$cell_ids))
)

trajectory <- add_linear_trajectory(dataset, pseudotime)
}
\keyword{create_trajectory}
