% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLSV.R
\name{plotLSV}
\alias{plotLSV}
\title{Plot Linear Sweep Voltammograms}
\usage{
plotLSV(filenames = list(file1 = NULL, file2 = NULL), legend_text = NULL,
  legend_position = c("topleft", "topright", "bottomleft", "bottomright"),
  main_title = NULL, line_widths = c(2, 2, 2, 2, 2), line_types = c(1, 2,
  3, 4, 5), point_symbols = c(21, 22, 23, 24, 25), line_colors = c("blue",
  "blue", "blue", "blue", "blue"))
}
\arguments{
\item{filenames}{A list giving the names of 1--5 files that contain the results of a simulated linear sweep voltammetry experiment.}

\item{legend_text}{Optional vector that contains text to include in a legend. Default is NULL, which surpresses the legend.}

\item{legend_position}{One of \code{topleft}, \code{topright}, \code{bottomleft}, or \code{bottomright}; defaults to \code{topleft}.}

\item{main_title}{An optional main title.}

\item{line_widths}{A vector of line widths for the individual linear sweep voltammograms; defaults to a common line width of 2, but can be adjusted by supplying a vector with desired values.}

\item{line_types}{A vector of line types for the individual linear sweep voltammograms; defaults to a set of different line types, but can be adjusted by supplying a vector with desired values.}

\item{point_symbols}{A vector of pch values for plotting points.}

\item{line_colors}{A vector of colors for the individual linear sweep voltammograms, whether displayed as lines or as points; defaults to a common color, but can be adjusted by supplying a vector with desired values.}
}
\value{
Returns a plot that shows the applied potential on the \emph{x}-axis and current on the \emph{y}-axis.
}
\description{
Plots 1--5 linear sweep voltammograms on a single set of axes.
The default plot does not include a legend or a title, but
providing a vector of character strings to legend_text adds a
legend to the final plot, and adding a character string for
main_title adds a title to the plot. Line widths, line types,
line colors, point symbols, and point colors have default
values that can be adjusted. Note: this function accepts both
full data files created using \code{lsvSim}, or reduced data
\code{sampleLSV}.
}
\examples{

lsv_ex1 = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "fast", x.units = 100, t.units = 1000)
lsv_ex2 = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "medium", x.units = 100, t.units = 1000)
lsv_ex3 = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "slow", x.units = 100, t.units = 1000)
lsv_ex4 = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "off", x.units = 100, t.units = 1000)
plotLSV(filenames = list(lsv_ex1, lsv_ex2, lsv_ex3, lsv_ex4),
  legend_text = c("stir rate: fast", "stir rate: medium",
  "stir rate: slow", "stir rate: off"))
}
