#' AMPURE
#'
#' Description: Placeholder for AMPURE dataset.
#'
#' @format A tibble/data.frame with X rows and Y columns:
#' \describe{
#'   \item{Column1}{Description of column1}
#'   \item{Column2}{Description of column2}
#'   ...
#' }
#' @source Generated by the Author
"AMPURE"

#' ASV_table
#'
#' An abundance table in long format. 
#'
#' Contains the number of reads from unique ASVs across different samples.
#'
#' @format A data frame with 9 rows and 3 variables:
#' \describe{
#'   \item{sample_name}{Character vector, last digit includes PCR replicate}
#'   \item{Hash}{The sequence found, hashed using sha1 for consistency}
#'   \item{nReads}{Number of times that hash was found in that sample}
#' }
#' @source Generated by the Author
"ASV_table"

#' example_hashes
#'
#' Placeholder description for example_hashes dataset.
#'
#' @format A vector or data frame with X rows/columns
#' @source Generated by the Author
"example_hashes"

#' metadata
#'
#' Placeholder description for metadata dataset.
#'
#' @format A data frame with X rows and Y columns:
#' \describe{
#'   \item{sample_name}{Name of sample}
#'   \item{Treatment}{either control or treatment}
#'    \item{Day}{either 1 or 2}
#' }
#' @source Generated by the Author
"metadata"

#' molarity.data
#'
#' Placeholder description for molarity.data dataset.
#'
#' @format A tibble/data.frame with X rows and Y columns
#' \describe{
#'   \item{Sample}{Name of sample}
#'   \item{Molarity}{in nM}
#'    \item{Amp_len}{length of amplicon in bp}
#'    \item{mass}{in ng/\eqn{\mu}l }
#' }
#' @source Generated by the Author
"molarity.data"

#' OTU_taxonomy
#'
#' Placeholder description for OTU_taxonomy dataset.
#'
#' @format A dataframe of DNA sequences names and their taxonomy, with 3 rows and 7 columns
#'  \describe{
#'   \item{Hash}{Sequence identifier}
#'   \item{Kingdom}{taxon info at that rank}
#'    \item{Phylum}{taxon info at that rank}
#'    \item{Class}{taxon info at that rank}
#'    \item{Order}{taxon info at that rank}
#'    \item{Family}{taxon info at that rank}
#'    \item{Genus}{taxon info at that rank}
#'    }
#' @source Generated by the Author
"OTU_taxonomy"

#' test_seqs
#'
#' Placeholder description for test_seqs dataset.
#'
#' 
#'    
#' 
#' @source Generated by the Author
"test_seqs"

#' training.ASV.table
#'
#' Placeholder description for training.ASV.table dataset.
#' @format A data frame with 1909 rows and 4 variables:
#' \describe{
#'   \item{Sample_name}{Character vector, last digit includes PCR replicate}
#'   \item{Locus}{Which locus the sequences are from, numeric}
#'   \item{Hash}{The sequence found, hashed using sha1 for consistency}
#'   \item{nReads}{Number of times that hash was found in that sample}
#' }
#' 
#' @source Generated by the Author
"training.ASV.table"

#' training.metadata
#'
#' Placeholder description for training.metadata dataset.
#'
#' @format A data frame with 95 rows and 8 columns
#' \describe{
#'   \item{Sample_name}{Character vector, last digit includes PCR replicate}
#'   \item{eDNA.sample}{Biological sample}
#'   \item{rep}{PCR replicate}
#'   \item{Transect}{Transect of origin}
#'    \item{position}{Stop in Transect}
#'    \item{depth}{in the water column}
#'    \item{lat}{latitude in decimal degrees}
#'    \item{lon}{longitude in decimal degrees}
#' }
#' @source Generated by the Author
"training.metadata"

#' tree
#'
#' Placeholder description for tree dataset.
#'
#' @format An object of class phylo or similar
#' @source Generated by the Author
"tree"

#' UDI_Indices
#'
#' Placeholder description for UDI_Indices dataset.
#'
#' @format A data frame with 384 rows and 6 columns
#' \describe{
#'   \item{Index}{Character vector}
#'   \item{Bases_in_Adapter_i7}{Seqs in i7}
#'   \item{Bases_for_Sample_Sheet_i7}{Seqs to include}
#'   \item{Bases_for_Sample_Sheet_i5}{Seqs to include in some illumina platoforms}
#'    \item{Bases_for_Sample_Sheet_i5_B}{Seqs to include in other illumina platoforms}
#'    \item{Set}{A, B, C, or D}
#' }
#' @source Generated by the Author, data from Illumina
"UDI_Indices"

#' Index_PCR
#'
#' Placeholder description for IndexPCR template web address.
#'
#' @format A character vector
#'
#' @source Generated by the Author, stored in googledrive
"Index_PCR"

#' template_PCR
#'
#' Placeholder description for Normal PCR template web address.
#'
#' @format A character vector
#'
#' @source Generated by the Author, stored in googledrive
"template_PCR"

#' ps
#'
#' Placeholder description for phyloseq object.
#'
#' @format Formal class 'phyloseq' with five slots
#'
#' @source Generated by the Author
"ps"