% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqplot}
\alias{qqplot}
\alias{qqplot.fcm}
\title{Q–Q Plot for Fitted Factor Copula Model}
\usage{
qqplot(object, ...)

\method{qqplot}{fcm}(
  object,
  which = 1,
  gpd = TRUE,
  thres = 0.9,
  main = "Q-Q plot",
  xlab = "Theoretical quantiles (exceedances)",
  ylab = "Empirical exceedances",
  ...
)
}
\arguments{
\item{object}{An object of class \code{"fcm"} returned by \code{\link[=fcm]{fcm()}}.}

\item{...}{Additional graphical arguments forwarded to \code{\link[=plot]{plot()}}.}

\item{which}{Integer scalar. Station (column) index to plot.}

\item{gpd}{Logical; if \code{TRUE}, add a GPD tail fit to the Q–Q plot.}

\item{thres}{Numeric in \code{(0,1)}; the probability threshold used to pick
the empirical quantile \code{u = quantile(x, thres)}. Defaults to \code{0.9}.}

\item{main, xlab, ylab}{Character. Graphical labels passed to \code{\link[=plot]{plot()}}.}
}
\value{
A numeric vector of fitted eFCM theoretical tail quantiles, invisibly returned.
}
\description{
Produce a Q–Q plot comparing empirical exceedances to the fitted eFCM tail,
with an optional GPD tail overlay for diagnostic comparison.
}
\details{
The function first selects a threshold \code{u} as the empirical
\code{thres}-quantile of the selected station series \code{x}.
It then forms exceedances \eqn{Y = X - u \mid X>u}, fits the eFCM
(implicitly via \code{qfcm()} and a scalar \eqn{\lambda} estimate),
and plots empirical exceedances against theoretical eFCM quantiles in the tail.
If \code{gpd=TRUE}, a GPD is fitted to the exceedances (threshold 0) and
its theoretical tail quantiles are added for visual comparison.
}
