% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_freetext.R
\name{skipgram_identify}
\alias{skipgram_identify}
\title{Identify Neighbouring Words (Skipgrams) in a free-text vector}
\usage{
skipgram_identify(
  x,
  ids,
  num_of_words = 2,
  max_interrupt_words = 2,
  words_to_rm = NULL,
  lan = "english"
)
}
\arguments{
\item{x}{Free-text character vector to query.}

\item{ids}{Character vector containing IDs for each element of \code{var}.}

\item{num_of_words}{Number of words to consider for each returned skipgram.
Default = 2.}

\item{max_interrupt_words}{Maximum number of words which can interrupt
proximal words. Default = 2.}

\item{words_to_rm}{Character vector of words which should not be considered.}

\item{lan}{Language of \code{var}. Default: \code{english}.}
}
\value{
Tibble containing skipgrams as variables and patient values as rows.
}
\description{
Identifies words which appear near each other in the free-text variable
(\code{var}), referred to as "Skipgrams". Supported languages for stop words
and stemming are \code{danish}, \code{dutch}, \code{english}, \code{finnish},
\code{french}, \code{german}, \code{hungarian}, \code{italian},
\code{norwegian}, \code{portuguese}, \code{russian}, \code{spanish}, and
\code{swedish}.
}
\examples{
data(example_data)
skipgram_identify(x = example_data$free_text,
                  ids = example_data$patient_id,
                  max_interrupt_words = 5)
}
\references{
Guthrie, D., Allison, B., Liu, W., Guthrie, L. & Wilks, Y. A
  Closer Look at Skip-gram Modelling. in Proceedings of the Fifth
  International Conference on Language Resources and Evaluation (LREC’06)
  (European Language Resources Association (ELRA), 2006).
  
  Benoit K, Watanabe K, Wang H, Nulty P, Obeng A, Müller S, Matsuo A (2018).
  “quanteda: An R package for the quantitative analysis of textual data.” _Journal
  of Open Source Software_, *3*(30), 774. doi:10.21105/joss.00774
  <https://doi.org/10.21105/joss.00774>, <https://quanteda.io>.
  
  Feinerer I, Hornik K (2020). _tm: Text Mining Package_. R package version 0.7-8,
  <https://CRAN.R-project.org/package=tm>.
  
  Ingo Feinerer, Kurt Hornik, and David Meyer (2008). Text Mining Infrastructure in
  R. Journal of Statistical Software 25(5): 1-54. URL:
  https://www.jstatsoft.org/v25/i05/.
}
\seealso{
Principle underlying function: \code{\link[quanteda]{tokens_ngrams}}

Other free text functions: 
\code{\link{extract_freetext}()},
\code{\link{skipgram_append}()},
\code{\link{skipgram_freq}()}
}
\concept{free text functions}
