% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_resample.R
\name{plot_resample_medians}
\alias{plot_resample_medians}
\title{Plot resample median distributions}
\usage{
plot_resample_medians(data, n_rows = 2, n_cols = 2, interactive = FALSE)
}
\arguments{
\item{data}{List of abc results from abc_resample}

\item{n_rows}{Number of rows in plot grid (default 2)}

\item{n_cols}{Number of columns in plot grid (default 2)}

\item{interactive}{Whether to pause between pages (default FALSE)}
}
\value{
No return value, called for side effects (plotting). Creates density
  plots displayed in the graphics device.
}
\description{
Plot density distributions of parameter medians across resample iterations.
}
\examples{
# Load ABC input data from example simulation
abc_input <- readRDS(
  system.file("extdata", "rdm_minimal", "abc", "abc_input.rds", package = "eam")
)

# Perform ABC resampling
results <- abc_resample(
  target = abc_input$target,
  param = abc_input$param,
  sumstat = abc_input$sumstat,
  n_iterations = 100,
  n_samples = 100,
  tol = 0.5,
  method = "rejection"
)

# plot the resample medians for each parameter
plot_resample_medians(results)
}
