% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identical.R
\name{identicalNoAttr}
\alias{identicalNoAttr}
\alias{identicalFMatch}
\title{Equality testing with some attributes ignored}
\usage{
identicalNoAttr(x, y, ignore.attrs = NULL, ...)

identicalFMatch(x, y, ...)
}
\arguments{
\item{x, y}{Any R objects.}

\item{ignore.attrs}{Names of attributes in `x` and `y`. The selected 
attributes will be removed before testing. Default is `NULL` (keep all 
attributes)}

\item{...}{Arguments passed to \code{\link{identical}}.}
}
\value{
A single logical value (`TRUE` or `FALSE`), same as \code{\link{identical}}.
}
\description{
A wrapper for function \code{\link{identical}}. Some attributes of the two 
objects can be ignored when testing.
}
\details{
`identicalFMatch` is a wrapper for `identicalNoAttr`, where `ignore.attrs` is 
set to `".match.hash"`. This function is helpful to test two vectors after 
using \code{\link[fastmatch]{fmatch}}, which add external hash tables to the 
compared vectors.
}
\examples{
x1 <- LETTERS[1:10]
x2 <- sample(x1, 5)
x3 <- x1[fastmatch::fmatch(x2, x1)]
identical(x3, x2)  ## TRUE, but x1 has the '.match.hash' attribute now.

identical(LETTERS[1:10], x1)  ## FALSE
identicalFMatch(x3, x2)  ## TRUE

}
