% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_OR_table.R
\name{create_OR_table}
\alias{create_OR_table}
\title{Create Odds Ratio Table}
\usage{
create_OR_table(
  ...,
  output_format = c("markdown", "latex", "html", "plaintext"),
  bootstrap_options = NULL
)
}
\arguments{
\item{...}{One or more logistic regression models.}

\item{output_format}{The output format for the table. Can be "markdown", "latex", "html", or "plaintext". Default is "plaintext".}

\item{bootstrap_options}{A character vector of Bootstrap table styles for HTML output. Default is NULL.}
}
\value{
Displays a formatted table of odds ratios with confidence intervals.
}
\description{
This function creates a table displaying odds ratios with confidence intervals
for logistic regression models.
}
\examples{
# Simulate data
set.seed(123)
dataset <- data.frame(
  response = sample(c(0, 1), 100, replace = TRUE),
  var1 = rnorm(100),
  var2 = rnorm(100),
  var3 = rnorm(100)
)

# Fit logistic regression models
model1 <- glm(response ~ var1 + var2, family = binomial, data = dataset)
model2 <- glm(response ~ var1 + var2 + var3, family = binomial, data = dataset)

# Create OR table as plaintext
create_OR_table(model1, model2)

# Create OR table with custom bootstrap options and HTML
create_OR_table(model1, model2, output_format="html", bootstrap_options = c("striped", "hover"))

}
