% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rect.R
\name{rect.svg}
\alias{rect.svg}
\title{Generate rectangle SVG element}
\usage{
rect.svg(x = NULL, y = NULL, width = NULL, height = NULL, rx = NULL,
  ry = NULL, fill, fill.opacity, stroke, stroke.width, stroke.opacity,
  stroke.dasharray, style.sheet = NULL)
}
\arguments{
\item{x}{a number, x coordinate information}

\item{y}{a number, y corrdinate information}

\item{width}{a number, width of the rect}

\item{height}{a number, height of the rect}

\item{rx}{a number, x coordinate of rounded rectangle}

\item{ry}{a number, y coordinate of rounded rectangle}

\item{fill}{a character, color of the rect, eg. "#000000"(default), "red"}

\item{fill.opacity}{a number, stroke opacity of the rect, default:1. If the fill opacity is 0, the rect's internal color is invisible}

\item{stroke}{a characher, color of the rect line, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the rect line, default: 1}

\item{stroke.opacity}{a number, stroke opacity of the rect line, default:1. If the stroke opacity is 0, the line is invisible}

\item{stroke.dasharray}{a vector, plot the dotted rect line, eg. c(9, 5)}

\item{style.sheet}{a vector or a chatacter, other style of the rect, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function can generate a rect form SVG element
The <rect> element is a basic SVG shape that creates rectangles,
defined by their corner's position, their width, and their height.
The rectangles may have their corners rounded.
}
\examples{
rect.svg(x = 1, y = 2, width = 10, height = 20, fill = "blue")
rect.svg(x = 1, y = 2, width = 10, height = 20, stroke.dasharray = c(9, 5))
rect.svg(x = 1, y = 2, width = 10, height = 20, rx = 2, ry = 4, fill = "blue")

}
