% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgm_plot_class.R
\name{complexity_probs}
\alias{complexity_probs}
\alias{plot_complexity_probabilities}
\title{Plot posterior complexity probabilities}
\usage{
plot_complexity_probabilities(output, ...)
}
\arguments{
\item{output}{Output object from the easybgm function. Supports also objects from the bgm function of the \code{bgms} package.}

\item{...}{Additional arguments passed onto \code{ggplot2}}
}
\value{
Returns a plot
}
\description{
Plots the posterior complexity probabilities of all visited structures, where complexity comprises the network density.
}
\examples{
\donttest{

library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)
fit <- easybgm(data, type = "ordinal", save = TRUE, edge_selection = TRUE,
                iter = 100  # for demonstration only (> 5e4 recommended)
                )

plot_complexity_probabilities(fit)
}
}
