% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingEAT.R
\name{rankingEAT}
\alias{rankingEAT}
\title{Ranking of Variables by Efficiency Analysis Trees model.}
\usage{
rankingEAT(object, barplot = TRUE, threshold = 70, digits = 2)
}
\arguments{
\item{object}{An \code{EAT} object.}

\item{barplot}{\code{logical}. If \code{TRUE}, a barplot with the importance scores is displayed.}

\item{threshold}{Importance score value in which a line is graphed.}

\item{digits}{Decimal units.}
}
\value{
\code{data.frame} with the importance scores and a barplot representing the the variable importance if \code{barplot = TRUE}.
}
\description{
This function computes the variable importance through an Efficiency Analysis Trees model.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

rankingEAT(object = EAT_model,
           barplot = TRUE,
           threshold = 70,
           digits = 2)
}

}
