% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.EBM}
\alias{predict.EBM}
\title{Predict method for EBM objects}
\usage{
\method{predict}{EBM}(
  object,
  newdata,
  type = c("response", "link", "class", "terms"),
  se_fit = FALSE,
  init_score = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \link{ebm} object.}

\item{newdata}{A data frame in which to look for variables with which to
predict.}

\item{type}{The type of prediction required. Current options include:
\itemize{
\item \code{"response"}: Returns predictions on the scale of the response variable.
Thus, for a categorical outcome (i.e., binary or multiclass), a matrix of
predicted probabilities is returned.
\item \code{"link"}: Returns predictions on the link scale. For a binary outcome with
logit link, for example, this results in a vector of logits. For a multiclass
outcome, this will return a matrix with one column for each class. Ignored
for regression problems.
\item \code{"class"}: Returns a vector predicted class label for categorical outcomes.
\item \code{"terms"}: Returns a matrix (or list of matrices for multiclass outcomes)
of the individual term contributions (e.g., the \code{f(x)}'s). Note that term
contributions are on the link scale, where they are additive.
}}

\item{se_fit}{Logical indicating whether or not standard errors are required.
Ignored for multiclass outcomes. Note that standard errors are only available
on the link scale.}

\item{init_score}{Optional. Either a model that can generate scores or
per-sample initialization score. If samples scores it should be the same
length as \code{newdata}.}

\item{...}{Additional optional arguments. (Currently ignored.)}
}
\value{
Either a vector, matrix, or list of results. See the \code{type} argument
for details.
}
\description{
Compute predicted values from a fitted explainable boosting machine.
}
