% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_group.R
\name{ebnm_group}
\alias{ebnm_group}
\title{Solve the EBNM problem for grouped data}
\usage{
ebnm_group(
  x,
  s = 1,
  group,
  prior_family = "point_normal",
  mode = 0,
  scale = "estimate",
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  ...
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and
missing standard errors are not allowed. Two prior families have
additional restrictions: when horseshoe priors are used, errors
must be homoskedastic; and since function
\code{\link[deconvolveR]{deconv}} in package \code{deconvolveR} takes
\eqn{z}-scores, the "deconvolver" family requires that all standard errors
be equal to 1.}

\item{group}{A vector of character strings that gives the group to which each
observation belongs. It must have the same length as argument \code{x}. For
an example of usage, see Examples below.}

\item{prior_family}{A named vector that specifies the prior family \eqn{G}
for each group. If the same prior family is to be used for all groups, then
a character string may be used instead.}

\item{mode}{A named list that specifies, for each group, the mode of the
respective prior \eqn{g}, or \code{"estimate"} if the mode is to be
estimated from the data. If the mode is the same across groups, then a
scalar may be used instead. If all modes are to be estimated, then
\code{mode = "estimate"} may be used.}

\item{scale}{A named list that specifies, for each group, the scale
parameter(s) of the respective prior, or \code{"estimate"} if the scale
parameters are to be estimated from the data. If the scale parameter is the
same across groups, then a scalar may be used instead. If all scales are to
be estimated, then \code{scale = "estimate"} may be used.}

\item{g_init}{The prior distributions \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. If
\code{g_init} is supplied, it should be a named list that specifies, for
each group, a prior of the appropriate class (\code{\link[ashr]{normalmix}}
for normal, point-normal,
scale mixture of normals, and \code{deconvolveR} prior families, as well as
for the NPMLE; class \code{\link{laplacemix}} for
point-Laplace families; class \code{\link{gammamix}} for point-exponential
families; class \code{\link{horseshoe}} for horseshoe families; and class
\code{\link[ashr]{unimix}} for \code{unimodal_} families).}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{...}{Additional parameters. When a \code{unimodal_} prior family is used,
these parameters are passed to function \code{\link[ashr]{ash}} in package
\code{ashr}. Although it
does not call into \code{ashr}, the scale mixture of normals family accepts
parameter \code{gridmult} for purposes of comparison. When \code{gridmult}
is set, an \code{ashr}-style grid will be used instead of the default
\code{ebnm} grid. When the "deconvolver" family is used, additional
parameters are passed to function \code{\link[deconvolveR]{deconv}} in
package \code{deconvolveR}. Families of generalized binary priors take several
additional parameters; see \code{\link{ebnm_generalized_binary}}. In all
other cases, additional parameters are ignored.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}} (an object of
        class \code{\link[ashr]{normalmix}}, \code{\link{laplacemix}},
        \code{\link{gammamix}}, \code{\link[ashr]{unimix}},
        \code{\link[ashr]{tnormalmix}}, or \code{\link{horseshoe}}).}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. For all prior families other
        than the horseshoe, the sampler takes a single parameter
        \code{nsamp}, the number of posterior samples to return per
        observation. Since \code{ebnm_horseshoe} returns an MCMC sampler,
        it additionally takes parameter \code{burn}, the number of burn-in
        samples to discard.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem for observations
  belonging to distinct groups.
}
\details{
The EBNM model for grouped data, with observations \eqn{x_j} belonging to
  groups \eqn{k = 1, ..., K}, is
  \deqn{x_j | \theta_j, s_j \sim N(\theta_j, s_j^2)}
  \deqn{\theta_j \sim g_{k(j)} \in G_{k(j)}.}

Solving the EBNM problem for grouped data is equivalent to solving a
  separate EBNM problem for each group \eqn{k = 1, ..., K}, with the optimal
  log likelihood equal to the sum of the optimal log likelihoods for each
  separate problem.
}
\examples{
group <- c(rep("small_sd", 100), rep("large_sd", 100))
theta <- c(rnorm(100, sd = 1), rnorm(100, sd = 10))
s <- 1
x <- theta + rnorm(200, 0, s)

ebnm.group.res <- ebnm_group(x, s, group)

# Use different prior families for each group:
ebnm.group.res <- ebnm_group(
  x, s, group,
  prior_family = list(small_sd = "normal", large_sd = "normal_scale_mixture")
)

# Different modes and scales can be set similarly:
ebnm.group.res <- ebnm_group(
  x, s, group,
  mode = list(small_sd = 0, large_sd = "estimate"),
  scale = list(small_sd = 1, large_sd = "estimate")
)

}
\seealso{
\code{\link{ebnm}}
}
