% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{eode_is_unsfoc}
\alias{eode_is_unsfoc}
\title{Unstable Focus}
\usage{
eode_is_unsfoc(x, value, eps = 0.001)
}
\arguments{
\item{x}{Object of class "\code{eode}" representing an ODE system.}

\item{value}{an object of class "\code{pp}" representing a phase point in the
ODE system under consideration.}

\item{eps}{Precision used to check whether the input phase point is an equilibrium
point. If the absolute value of any component of the phase velocity vector at a
phase point is lower than \code{eps}, an error would be thrown out.}
}
\value{
a \code{TRUE} or \code{FALSE}.
}
\description{
Check whether an equilibrium point is an unstable focus or not.
}
\examples{
eq1 <- function(x, y, r1 = 1, a11 = 2, a12 = 1) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 1, a22 = 2) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
eode_is_unsfoc(x, value = pp(list(x = 0.3333, y = 0.3333)))
}
