% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prototype.R
\name{eode_set_constraint}
\alias{eode_set_constraint}
\title{Set New Constraints}
\usage{
eode_set_constraint(x, new_constraint)
}
\arguments{
\item{x}{an object of class "\code{eode}".}

\item{new_constraint}{a vector of characters indicating new constraints
to be assigned to the ODE system.}
}
\value{
an object of "\code{eode}" class
}
\description{
Set new constraints for an ODE system.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
x
eode_set_constraint(x, c("x<5", "y<5"))
}
